/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.flmelody.core.AbstractRouterGroup;
import org.flmelody.core.DefaultRouterGroup;
import org.flmelody.core.Handler;
import org.flmelody.core.HttpServer;
import org.flmelody.core.LoggingHandler;
import org.flmelody.core.Router;
import org.flmelody.core.RouterGroup;
import org.flmelody.core.WindwardContext;
import org.flmelody.core.netty.NettyHttpServer;

public class Windward
implements Router {
    private static AbstractRouterGroup baseRouterGroup;
    private static final List<AbstractRouterGroup> routerGroups;
    private static final List<Handler> globalHandlers;
    private HttpServer httpServer;

    private Windward(String relativePath) {
        baseRouterGroup = new DefaultRouterGroup(relativePath);
    }

    public static Windward setup() {
        return Windward.setup(8080, new LoggingHandler());
    }

    public static Windward setup(int port, Handler ... handlers) {
        return Windward.setup(port, "/", handlers);
    }

    public static Windward setup(int port, String relativePath, Handler ... handlers) {
        Windward windward = new Windward(relativePath);
        windward.httpServer = new NettyHttpServer(port);
        return windward.registerHandler(handlers);
    }

    public void run() throws Exception {
        this.httpServer.run();
    }

    public RouterGroup group(String relativePath) {
        DefaultRouterGroup defaultRouterGroup = new DefaultRouterGroup(relativePath);
        routerGroups.add(defaultRouterGroup);
        return defaultRouterGroup;
    }

    public Windward registerHandler(Handler ... handlers) {
        if (handlers == null || handlers.length == 0) {
            return this;
        }
        globalHandlers.addAll(Arrays.asList(handlers));
        return this;
    }

    public static Object findRouter(String relativePath, String method) {
        for (AbstractRouterGroup routerGroup : routerGroups) {
            Object o = routerGroup.matchRouter(relativePath, method);
            if (o == null) continue;
            return o;
        }
        return baseRouterGroup.matchRouter(relativePath, method);
    }

    public static List<Handler> handlers() {
        return globalHandlers;
    }

    public Windward then() {
        return this;
    }

    @Override
    public <R> Windward get(String relativePath, Supplier<R> supplier) {
        baseRouterGroup.get(relativePath, supplier);
        return this;
    }

    @Override
    public Windward get(String relativePath, Consumer<? extends WindwardContext> consumer) {
        baseRouterGroup.get(relativePath, consumer);
        return this;
    }

    @Override
    public <R> Router put(String relativePath, Supplier<R> supplier) {
        baseRouterGroup.put(relativePath, supplier);
        return this;
    }

    @Override
    public Windward put(String relativePath, Consumer<? extends WindwardContext> consumer) {
        baseRouterGroup.get(relativePath, consumer);
        return this;
    }

    @Override
    public <R> Router post(String relativePath, Supplier<R> supplier) {
        baseRouterGroup.post(relativePath, supplier);
        return this;
    }

    @Override
    public Windward post(String relativePath, Consumer<? extends WindwardContext> consumer) {
        baseRouterGroup.get(relativePath, consumer);
        return this;
    }

    @Override
    public <R> Router delete(String relativePath, Supplier<R> supplier) {
        baseRouterGroup.delete(relativePath, supplier);
        return this;
    }

    @Override
    public Windward delete(String relativePath, Consumer<? extends WindwardContext> consumer) {
        baseRouterGroup.get(relativePath, consumer);
        return this;
    }

    static {
        routerGroups = new ArrayList<AbstractRouterGroup>();
        globalHandlers = new ArrayList<Handler>();
    }
}

