/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core;

import java.util.List;
import org.flmelody.core.HttpStatus;
import org.flmelody.core.WindwardRequest;
import org.flmelody.core.WindwardResponse;

public class WindwardContext {
    private final WindwardRequest windwardRequest;
    private final WindwardResponse windwardResponse;
    private Boolean closed = Boolean.FALSE;

    public WindwardContext(WindwardRequest windwardRequest, WindwardResponse windwardResponse) {
        this.windwardRequest = windwardRequest;
        this.windwardResponse = windwardResponse;
    }

    public <P> P getRequestParameter(String parameterName) {
        List<String> parameters = this.windwardRequest.getQuerystring().get(parameterName);
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        return (P)parameters.get(0);
    }

    public List<String> getRequestParameters(String parameterName) {
        return this.windwardRequest.getQuerystring().get(parameterName);
    }

    public String getRequestBody() {
        return this.windwardRequest.getRequestBody();
    }

    public WindwardRequest windwardRequest() {
        return this.windwardRequest;
    }

    public void close() {
        this.closed = Boolean.TRUE;
    }

    public Boolean isClosed() {
        return this.closed;
    }

    public <T> void json(T data) {
        this.json(HttpStatus.OK.value(), data);
    }

    public <T> void json(int code, T data) {
        this.windwardResponse.write(code, "application/json", data);
    }

    public void string(String data) {
        this.string(HttpStatus.OK.value(), data);
    }

    public void string(int code, String data) {
        this.windwardResponse.write(code, "text/plain", data);
    }
}

