/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WindwardRequest {
    private String method;
    private String uri;
    private Boolean keepAlive;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, List<String>> querystring = new HashMap<String, List<String>>();
    private String requestBody;

    public static WindwardRequestBuilder newBuild() {
        return new WindwardRequestBuilder(new WindwardRequest());
    }

    private WindwardRequest() {
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getHeader(String name) {
        if (!this.headers.containsKey(name)) {
            return Collections.emptyList();
        }
        return this.headers.get(name);
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, List<String>> getQuerystring() {
        return this.querystring;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public static class WindwardRequestBuilder {
        private final WindwardRequest windwardRequest;

        private WindwardRequestBuilder(WindwardRequest windwardRequest) {
            this.windwardRequest = windwardRequest;
        }

        public WindwardRequestBuilder method(String method) {
            this.windwardRequest.method = method;
            return this;
        }

        public WindwardRequestBuilder uri(String uri) {
            this.windwardRequest.uri = uri;
            return this;
        }

        public WindwardRequestBuilder keepAlive(Boolean keepAlive) {
            this.windwardRequest.keepAlive = keepAlive;
            return this;
        }

        public WindwardRequestBuilder headers(Map<String, List<String>> headers) {
            this.windwardRequest.headers.putAll(headers);
            return this;
        }

        public WindwardRequestBuilder querystring(Map<String, List<String>> querystring) {
            this.windwardRequest.querystring.putAll(querystring);
            return this;
        }

        public WindwardRequestBuilder requestBody(String requestBody) {
            this.windwardRequest.requestBody = requestBody;
            return this;
        }

        public WindwardRequest build() {
            return this.windwardRequest;
        }
    }
}

