/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.util;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Objects;
import java.util.Set;
import org.flmelody.core.exception.ValidationException;
import org.flmelody.util.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationUtil {
    private static final ValidatorFactory validatorFactory;
    private static final Logger logger;

    public static <T> T validate(String content, Class<T> targetClass, Class<?> ... groups) throws ValidationException {
        Validator validator = validatorFactory.getValidator();
        T target = JacksonUtil.toObject(content, targetClass);
        Set validate = Objects.isNull(groups) ? validator.validate(target, new Class[0]) : validator.validate(target, (Class[])groups);
        if (Objects.nonNull(validate) && !validate.isEmpty()) {
            ConstraintViolation constraintViolation = (ConstraintViolation)validate.stream().findFirst().get();
            throw new ValidationException(constraintViolation.getPropertyPath() + " " + constraintViolation.getMessage());
        }
        return target;
    }

    static {
        logger = LoggerFactory.getLogger(ValidationUtil.class);
        try {
            validatorFactory = Validation.buildDefaultValidatorFactory();
        }
        catch (Throwable e) {
            logger.error("Failed to init validator", e);
            throw e;
        }
    }
}

