/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.flmelody.core.FunctionMetaInfo;
import org.flmelody.core.HttpMethod;
import org.flmelody.core.Router;
import org.flmelody.core.RouterGroup;
import org.flmelody.core.context.EmptyWindwardContext;
import org.flmelody.core.context.EnhancedWindwardContext;
import org.flmelody.core.context.SimpleWindwardContext;
import org.flmelody.core.context.WindwardContext;
import org.flmelody.util.UrlUtil;

public abstract class AbstractRouterGroup
implements RouterGroup {
    private String groupPath;
    private final Map<String, Map<String, ? super Object>> routers = new HashMap<String, Map<String, ? super Object>>();

    protected AbstractRouterGroup() {
        this("/");
    }

    protected AbstractRouterGroup(String groupPath) {
        this.setGroupPath(groupPath);
    }

    protected void setGroupPath(String groupPath) {
        if (!groupPath.startsWith("/")) {
            groupPath = "/" + groupPath;
        }
        this.groupPath = groupPath;
    }

    @Override
    public <R> Router get(String relativePath, Supplier<R> supplier) {
        this.registerRouter(relativePath, HttpMethod.GET.name(), supplier, EmptyWindwardContext.class);
        return this;
    }

    @Override
    public Router get(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.registerRouter(relativePath, HttpMethod.GET.name(), consumer, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public Router get(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.registerRouter(relativePath, HttpMethod.GET.name(), function, EnhancedWindwardContext.class);
        return this;
    }

    @Override
    public <R> Router put(String relativePath, Supplier<R> supplier) {
        this.registerRouter(relativePath, HttpMethod.PUT.name(), supplier, EmptyWindwardContext.class);
        return this;
    }

    @Override
    public Router put(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.registerRouter(relativePath, HttpMethod.PUT.name(), consumer, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public Router put(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.registerRouter(relativePath, HttpMethod.PUT.name(), function, EnhancedWindwardContext.class);
        return this;
    }

    @Override
    public <R> Router post(String relativePath, Supplier<R> supplier) {
        this.registerRouter(relativePath, HttpMethod.POST.name(), supplier, EmptyWindwardContext.class);
        return this;
    }

    @Override
    public Router post(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.registerRouter(relativePath, HttpMethod.POST.name(), consumer, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public Router post(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.registerRouter(relativePath, HttpMethod.POST.name(), function, EnhancedWindwardContext.class);
        return this;
    }

    @Override
    public <R> Router delete(String relativePath, Supplier<R> supplier) {
        this.registerRouter(relativePath, HttpMethod.DELETE.name(), supplier, EmptyWindwardContext.class);
        return this;
    }

    @Override
    public Router delete(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.registerRouter(relativePath, HttpMethod.DELETE.name(), consumer, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public Router delete(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.registerRouter(relativePath, HttpMethod.DELETE.name(), function, EnhancedWindwardContext.class);
        return this;
    }

    @Override
    public <R> R matchRouter(String relativePath, String method) {
        if (!relativePath.startsWith(this.groupPath)) {
            return null;
        }
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.replaceFirst("/$", "");
        }
        if (!this.routers.containsKey(relativePath)) {
            return null;
        }
        return (R)this.routers.get(relativePath).get(method);
    }

    private <I> void registerRouter(String relativePath, String method, I i, Class<? extends WindwardContext> clazz) {
        String path = UrlUtil.buildUrl(this.groupPath, relativePath);
        FunctionMetaInfo<I> functionMetaInfo = new FunctionMetaInfo<I>(i, clazz);
        if (this.routers.containsKey(path)) {
            this.routers.get(path).put(method, functionMetaInfo);
        } else {
            HashMap<String, FunctionMetaInfo<I>> routerMap = new HashMap<String, FunctionMetaInfo<I>>(16);
            routerMap.put(method, functionMetaInfo);
            this.routers.put(path, routerMap);
        }
    }
}

