/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.flmelody.core.ResponseWriter;
import org.flmelody.util.JacksonUtil;

public class NettyResponseWriter
implements ResponseWriter {
    private final ChannelHandlerContext ctx;

    public NettyResponseWriter(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public <T> void write(int code, T data) {
        this.write(code, "application/json", data);
    }

    @Override
    public <T> void write(int code, String contentType, T data) {
        this.write(code, contentType, data, true);
    }

    @Override
    public <T> void write(int code, String contentType, T data, boolean close) {
        Channel channel = this.ctx.channel();
        if (!channel.isActive()) {
            return;
        }
        String response = null;
        if ("application/json".equals(contentType)) {
            response = JacksonUtil.toJson(data);
        } else if ("text/plain".equals(contentType)) {
            response = String.valueOf(data);
        }
        if (response == null) {
            this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)response, (Charset)CharsetUtil.UTF_8));
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        if (!close) {
            httpResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, httpResponse.content().readableBytes());
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        this.ctx.write((Object)httpResponse);
        if (close) {
            this.close();
        }
    }

    @Override
    public <T> void writeAndClose(int code, String contentType, T data) {
        this.write(code, contentType, data, Boolean.TRUE);
    }

    @Override
    public void close() {
        this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

