/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.flmelody.core.AbstractRouterGroup;
import org.flmelody.core.AutoJsonBinder;
import org.flmelody.core.DefaultRouterGroup;
import org.flmelody.core.ExceptionHandler;
import org.flmelody.core.Filter;
import org.flmelody.core.FunctionMetaInfo;
import org.flmelody.core.HttpServer;
import org.flmelody.core.LoggingFilter;
import org.flmelody.core.Router;
import org.flmelody.core.RouterGroup;
import org.flmelody.core.context.EnhancedWindwardContext;
import org.flmelody.core.context.SimpleWindwardContext;
import org.flmelody.core.exception.PluginMissException;
import org.flmelody.core.exception.ServerException;
import org.flmelody.core.netty.NettyHttpServer;
import org.flmelody.core.plugin.Plugin;
import org.flmelody.core.plugin.json.JsonPlugin;
import org.flmelody.util.UrlUtil;

public class Windward
implements Router {
    private final String contextPath;
    private static final List<AbstractRouterGroup> routerGroups = new ArrayList<AbstractRouterGroup>();
    private static final List<Filter> globalFilters = new ArrayList<Filter>();
    private static final List<ExceptionHandler> globalExceptionHandlers = new ArrayList<ExceptionHandler>();
    private static final Map<Class<?>, Plugin> globalPlugins = new HashMap();
    private HttpServer httpServer;

    private Windward(String contextPath) {
        this.contextPath = contextPath;
    }

    public static Windward setup() {
        return Windward.setup(8080, new LoggingFilter());
    }

    public static Windward setup(int port, Filter ... filters) {
        return Windward.setup(port, "/", filters);
    }

    public static Windward setup(int port, String contextPath, Filter ... filters) {
        Windward windward = new Windward(contextPath);
        windward.httpServer = new NettyHttpServer(port);
        return windward.registerFilter(filters).registerPlugin(JsonPlugin.class, AutoJsonBinder.jsonPlugin);
    }

    public void run() throws ServerException {
        this.httpServer.run();
    }

    public RouterGroup group(String relativePath) {
        DefaultRouterGroup defaultRouterGroup = new DefaultRouterGroup(UrlUtil.buildUrl(this.contextPath, relativePath));
        routerGroups.add(defaultRouterGroup);
        return defaultRouterGroup;
    }

    public Windward registerFilter(Filter ... filters) {
        if (filters == null || filters.length == 0) {
            return this;
        }
        globalFilters.addAll(Arrays.asList(filters));
        return this;
    }

    public Windward registerExceptionHandler(ExceptionHandler ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this;
        }
        globalExceptionHandlers.addAll(Arrays.asList(exceptionHandlers));
        return this;
    }

    public Windward registerPlugin(Class<? extends Plugin> clazz, Plugin plugin) {
        globalPlugins.put(clazz, plugin);
        return this;
    }

    public static <I> FunctionMetaInfo<I> findRouter(String relativePath, String method) {
        for (AbstractRouterGroup routerGroup : routerGroups) {
            FunctionMetaInfo functionMetaInfo = (FunctionMetaInfo)routerGroup.matchRouter(relativePath, method);
            if (functionMetaInfo == null) continue;
            return functionMetaInfo;
        }
        return null;
    }

    public static List<Filter> filters() {
        return globalFilters;
    }

    public static List<ExceptionHandler> exceptionHandlers() {
        return globalExceptionHandlers;
    }

    public static <T extends Plugin> T plugin(Class<T> clazz) {
        if (!globalPlugins.containsKey(clazz)) {
            throw new PluginMissException(String.format("Plugin [%s] not found", clazz.getName()));
        }
        return (T)globalPlugins.get(clazz);
    }

    public Windward then() {
        return this;
    }

    @Override
    public <R> Windward get(String relativePath, Supplier<R> supplier) {
        this.group("/").get(relativePath, supplier);
        return this;
    }

    @Override
    public Windward get(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.group("/").get(relativePath, consumer);
        return this;
    }

    @Override
    public Router get(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.group("/").get(relativePath, function);
        return this;
    }

    @Override
    public <R> Router put(String relativePath, Supplier<R> supplier) {
        this.group("/").put(relativePath, supplier);
        return this;
    }

    @Override
    public Windward put(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.group("/").put(relativePath, consumer);
        return this;
    }

    @Override
    public Router put(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.group("/").put(relativePath, function);
        return this;
    }

    @Override
    public <R> Router post(String relativePath, Supplier<R> supplier) {
        this.group("/").post(relativePath, supplier);
        return this;
    }

    @Override
    public Windward post(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.group("/").post(relativePath, consumer);
        return this;
    }

    @Override
    public Router post(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.group("/").post(relativePath, function);
        return this;
    }

    @Override
    public <R> Router delete(String relativePath, Supplier<R> supplier) {
        this.group("/").delete(relativePath, supplier);
        return this;
    }

    @Override
    public Windward delete(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.group("/").delete(relativePath, consumer);
        return this;
    }

    @Override
    public Router delete(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.group("/").delete(relativePath, function);
        return this;
    }
}

