/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.context;

import java.util.HashMap;
import java.util.List;
import org.flmelody.core.HttpStatus;
import org.flmelody.core.WindwardRequest;
import org.flmelody.core.WindwardResponse;
import org.flmelody.core.context.WindwardContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractWindwardContext
implements WindwardContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWindwardContext.class);
    private final WindwardRequest windwardRequest;
    private final WindwardResponse windwardResponse;
    private Boolean closed = Boolean.FALSE;

    protected AbstractWindwardContext(WindwardRequest windwardRequest, WindwardResponse windwardResponse) {
        this.windwardRequest = windwardRequest;
        this.windwardResponse = windwardResponse;
    }

    @Override
    public <P> P getRequestParameter(String parameterName) {
        List<String> parameters = this.windwardRequest.getQuerystring().get(parameterName);
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        return (P)parameters.get(0);
    }

    @Override
    public List<String> getRequestParameters(String parameterName) {
        return this.windwardRequest.getQuerystring().get(parameterName);
    }

    @Override
    public String getRequestBody() {
        return this.windwardRequest.getRequestBody();
    }

    @Override
    public WindwardRequest windwardRequest() {
        return this.windwardRequest;
    }

    @Override
    public void close() {
        this.closed = Boolean.TRUE;
    }

    @Override
    public Boolean isClosed() {
        return this.closed;
    }

    @Override
    public <I> I readJson(Class<I> clazz) {
        return this.windwardRequest.readJson(clazz);
    }

    @Override
    public <I> I bindJson(Class<I> clazz, Class<?> ... groups) {
        return this.windwardRequest.bindJson(clazz, groups);
    }

    @Override
    public <T> void writeJson(T data) {
        this.writeJson(HttpStatus.OK.value(), data);
    }

    @Override
    public <T> void writeJson(int code, T data) {
        this.windwardResponse.write(code, "application/json", data);
    }

    @Override
    public void writeString(String data) {
        this.writeString(HttpStatus.OK.value(), data);
    }

    @Override
    public void writeString(int code, String data) {
        this.windwardResponse.write(code, "text/plain", data);
    }

    @Override
    public void redirect(String redirectUrl) {
        this.redirect(HttpStatus.FOUND.value(), redirectUrl);
    }

    @Override
    public void redirect(int code, String redirectUrl) {
        if (HttpStatus.MOVED_PERMANENTLY.value() == code || HttpStatus.FOUND.value() == code) {
            HashMap<String, Object> headerMap = new HashMap<String, Object>();
            headerMap.put("location", redirectUrl);
            this.windwardResponse.write(code, "text/plain", headerMap, null);
            return;
        }
        throw new IllegalArgumentException("Illegal redirecting code" + code);
    }
}

