/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.flmelody.core.exception.JsonDeserializeException;
import org.flmelody.core.exception.JsonSerializeException;
import org.flmelody.core.plugin.json.JsonPlugin;

public class GsonPlugin
implements JsonPlugin {
    final Gson gson = new GsonBuilder().serializeNulls().create();

    @Override
    public <I> String toJson(I data) {
        try {
            return this.gson.toJson(data);
        }
        catch (Exception e) {
            throw new JsonSerializeException(e);
        }
    }

    @Override
    public <O> O toObject(String json, Class<O> clazz) {
        try {
            return (O)this.gson.fromJson(json, clazz);
        }
        catch (Exception e) {
            throw new JsonDeserializeException(e);
        }
    }
}

