/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.flmelody.core.exception.JsonDeserializeException;
import org.flmelody.core.exception.JsonSerializeException;

public class JacksonUtil {
    static final ObjectMapper objectMapper = new ObjectMapper();

    private JacksonUtil() {
    }

    public static <I> String toJson(I data) {
        try {
            return objectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializeException(e);
        }
    }

    public static <O> O toObject(String json, Class<O> clazz) {
        try {
            return (O)objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new JsonDeserializeException(e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

