/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.util;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.flmelody.core.exception.ValidationException;
import org.flmelody.core.plugin.json.JsonPlugin;

public final class ValidationUtil {
    private static final ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();

    private ValidationUtil() {
    }

    public static <T> T validate(JsonPlugin jsonPlugin, String content, Class<T> targetClass, Class<?> ... groups) throws ValidationException {
        Validator validator = validatorFactory.getValidator();
        T target = jsonPlugin.toObject(content, targetClass);
        Set validate = Objects.isNull(groups) ? validator.validate(target, new Class[0]) : validator.validate(target, (Class[])groups);
        Optional first = validate.stream().findFirst();
        if (first.isPresent()) {
            ConstraintViolation constraintViolation = (ConstraintViolation)first.get();
            throw new ValidationException(constraintViolation.getPropertyPath() + " " + constraintViolation.getMessage());
        }
        return target;
    }
}

