/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flmelody.core.FunctionMetaInfo;
import org.flmelody.core.HttpMethod;
import org.flmelody.core.RouterGroup;
import org.flmelody.core.context.EnhancedWindwardContext;
import org.flmelody.core.context.SimpleWindwardContext;
import org.flmelody.core.context.WindwardContext;
import org.flmelody.core.exception.RouterMappingException;
import org.flmelody.util.UrlUtil;

public abstract class AbstractRouterGroup
implements RouterGroup {
    private String groupPath;
    private final Map<String, Map<String, ? super Object>> routers = Collections.synchronizedMap(new LinkedHashMap(16));

    protected AbstractRouterGroup() {
        this("/");
    }

    protected AbstractRouterGroup(String groupPath) {
        this.setGroupPath(groupPath);
    }

    protected void setGroupPath(String groupPath) {
        if (!groupPath.startsWith("/")) {
            groupPath = "/" + groupPath;
        }
        this.groupPath = groupPath;
    }

    @Override
    public <R> RouterGroup get(String relativePath, Supplier<R> supplier) {
        this.registerRouter(relativePath, HttpMethod.GET.name(), supplier, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public RouterGroup get(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.registerRouter(relativePath, HttpMethod.GET.name(), consumer, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public RouterGroup get(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.registerRouter(relativePath, HttpMethod.GET.name(), function, EnhancedWindwardContext.class);
        return this;
    }

    @Override
    public <R> RouterGroup put(String relativePath, Supplier<R> supplier) {
        this.registerRouter(relativePath, HttpMethod.PUT.name(), supplier, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public RouterGroup put(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.registerRouter(relativePath, HttpMethod.PUT.name(), consumer, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public RouterGroup put(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.registerRouter(relativePath, HttpMethod.PUT.name(), function, EnhancedWindwardContext.class);
        return this;
    }

    @Override
    public <R> RouterGroup post(String relativePath, Supplier<R> supplier) {
        this.registerRouter(relativePath, HttpMethod.POST.name(), supplier, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public RouterGroup post(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.registerRouter(relativePath, HttpMethod.POST.name(), consumer, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public RouterGroup post(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.registerRouter(relativePath, HttpMethod.POST.name(), function, EnhancedWindwardContext.class);
        return this;
    }

    @Override
    public <R> RouterGroup delete(String relativePath, Supplier<R> supplier) {
        this.registerRouter(relativePath, HttpMethod.DELETE.name(), supplier, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public RouterGroup delete(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.registerRouter(relativePath, HttpMethod.DELETE.name(), consumer, SimpleWindwardContext.class);
        return this;
    }

    @Override
    public RouterGroup delete(String relativePath, Function<EnhancedWindwardContext, ?> function) {
        this.registerRouter(relativePath, HttpMethod.DELETE.name(), function, EnhancedWindwardContext.class);
        return this;
    }

    @Override
    public <R> R matchRouter(String relativePath, String method) {
        if (!relativePath.startsWith(this.groupPath)) {
            return null;
        }
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.replaceFirst("/$", "");
        }
        if (!this.routers.containsKey(relativePath = relativePath.replaceAll("[{}]", ""))) {
            Set<String> routerKeys = this.routers.keySet();
            for (String routerKey : routerKeys) {
                String routerRegex;
                Pattern compiledPattern = Pattern.compile("\\{(.*?)}");
                Matcher compiledMatcher = compiledPattern.matcher(routerKey);
                if (!compiledMatcher.find() || !relativePath.matches(routerRegex = routerKey.replaceAll("\\{(.*?)}", "(.+)"))) continue;
                FunctionMetaInfo functionMetaInfo = (FunctionMetaInfo)this.routers.get(routerKey).get(method);
                if (functionMetaInfo == null) {
                    return null;
                }
                Map<String, Object> pathVariables = functionMetaInfo.getPathVariables();
                ArrayList<String> keys = new ArrayList<String>(pathVariables.keySet());
                Pattern pattern = Pattern.compile(routerRegex);
                Matcher matcher = pattern.matcher(relativePath);
                int groupCount = matcher.groupCount();
                while (matcher.find()) {
                    for (int j = 0; j < Math.min(groupCount, keys.size()); ++j) {
                        pathVariables.put((String)keys.get(j), matcher.group(j + 1));
                    }
                }
                return (R)functionMetaInfo;
            }
            return null;
        }
        return (R)this.routers.get(relativePath).get(method);
    }

    private <I> void registerRouter(String relativePath, String method, I i, Class<? extends WindwardContext> clazz) {
        String path = UrlUtil.buildUrl(this.groupPath, relativePath);
        Map<String, Object> pathVariables = this.checkPlaceholder(path);
        FunctionMetaInfo<I> functionMetaInfo = new FunctionMetaInfo<I>(i, clazz, pathVariables);
        if (this.routers.containsKey(path)) {
            this.routers.get(path).put(method, functionMetaInfo);
        } else {
            HashMap<String, FunctionMetaInfo<I>> routerMap = new HashMap<String, FunctionMetaInfo<I>>(16);
            routerMap.put(method, functionMetaInfo);
            this.routers.put(path, routerMap);
        }
    }

    private Map<String, Object> checkPlaceholder(String path) {
        LinkedHashMap<String, Object> pathVariables = new LinkedHashMap<String, Object>(16);
        Pattern pattern = Pattern.compile("(\\{(.*?)})");
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            String variable = matcher.group(2);
            if (variable.trim().isEmpty()) {
                throw new RouterMappingException("Path variable name is empty!");
            }
            pathVariables.put(variable, null);
        }
        return pathVariables;
    }
}

