/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.flmelody.core.ResponseWriter;
import org.flmelody.core.Windward;
import org.flmelody.core.plugin.json.JsonPlugin;

public class NettyResponseWriter
implements ResponseWriter {
    private final ChannelHandlerContext ctx;

    public NettyResponseWriter(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public <T> void write(int code, T data) {
        this.write(code, "application/json", data);
    }

    @Override
    public <T> void write(int code, String contentType, T data) {
        this.write(code, contentType, data, true);
    }

    @Override
    public <T> void write(int code, String contentType, T data, boolean close) {
        this.write(code, contentType, Collections.emptyMap(), data, close);
    }

    @Override
    public <T> void write(int code, String contentType, Map<String, Object> headers, T data, boolean close) {
        Channel channel = this.ctx.channel();
        if (!channel.isActive()) {
            return;
        }
        String response = null;
        if ("application/json".equals(contentType)) {
            response = Windward.plugin(JsonPlugin.class).toJson(data);
        } else if ("text/plain".equals(contentType)) {
            response = String.valueOf(data);
        }
        if (response == null) {
            this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)response, (Charset)CharsetUtil.UTF_8));
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        httpResponse.setStatus(HttpResponseStatus.valueOf((int)code));
        if (headers != null && !headers.isEmpty()) {
            headers.keySet().forEach(arg_0 -> NettyResponseWriter.lambda$write$0((FullHttpResponse)httpResponse, headers, arg_0));
        }
        if (!close) {
            httpResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, httpResponse.content().readableBytes());
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        this.ctx.write((Object)httpResponse);
        if (close) {
            this.close();
        }
    }

    @Override
    public <T> void writeAndClose(int code, String contentType, T data) {
        this.write(code, contentType, data, Boolean.TRUE);
    }

    @Override
    public void close() {
        this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static /* synthetic */ void lambda$write$0(FullHttpResponse httpResponse, Map headers, String key) {
        httpResponse.headers().set(key, headers.get(key));
    }
}

