/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.json;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.flmelody.core.exception.JsonDeserializeException;
import org.flmelody.core.exception.JsonSerializeException;
import org.flmelody.core.plugin.json.JsonPlugin;

public class JacksonPlugin
implements JsonPlugin {
    final ObjectMapper objectMapper = new ObjectMapper();

    public JacksonPlugin() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);
    }

    @Override
    public <I> String toJson(I data) {
        try {
            if (data instanceof String) {
                try {
                    String result = String.valueOf(data);
                    this.objectMapper.readTree(result);
                    return result;
                }
                catch (JacksonException result) {
                    // empty catch block
                }
            }
            return this.objectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializeException(e);
        }
    }

    @Override
    public <O> O toObject(String json, Class<O> clazz) {
        try {
            return (O)this.objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new JsonDeserializeException(e);
        }
    }
}

