/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.flmelody.core.exception.JsonDeserializeException;
import org.flmelody.core.exception.JsonSerializeException;

public class GsonUtil {
    static final Gson gson = new GsonBuilder().serializeNulls().create();

    private GsonUtil() {
    }

    public static <I> String toJson(I data) {
        try {
            return gson.toJson(data);
        }
        catch (Exception e) {
            throw new JsonSerializeException(e);
        }
    }

    public static <O> O toObject(String json, Class<O> clazz) {
        try {
            return (O)gson.fromJson(json, clazz);
        }
        catch (Exception e) {
            throw new JsonDeserializeException(e);
        }
    }
}

