/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.view.thymeleaf;

import java.util.Map;
import nz.net.ultraq.thymeleaf.layoutdialect.LayoutDialect;
import org.flmelody.core.plugin.view.AbstractViewPlugin;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafView
extends AbstractViewPlugin {
    protected final TemplateEngine templateEngine;
    private static final String viewExtension = "html";
    private final boolean useDialect;

    public ThymeleafView() {
        this(null, viewExtension);
    }

    public ThymeleafView(String templateLocation, String defaultExtension) {
        super(templateLocation, defaultExtension);
        boolean existDialect;
        try {
            Class.forName("nz.net.ultraq.thymeleaf.layoutdialect.LayoutDialect");
            existDialect = true;
        }
        catch (ClassNotFoundException ignored) {
            existDialect = false;
        }
        this.useDialect = existDialect;
        this.templateEngine = new TemplateEngine();
        this.templateEngine.setTemplateResolver((ITemplateResolver)new ClassLoaderTemplateResolver());
        if (this.useDialect) {
            this.templateEngine.setDialect((IDialect)new LayoutDialect());
        }
    }

    @Override
    public String render(String viewUrl, Map<String, Object> model) throws Exception {
        Context context = new Context();
        context.setVariables(model);
        return this.templateEngine.process(viewUrl, (IContext)context);
    }
}

