/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flmelody.core.DefaultRequestReader;
import org.flmelody.core.RequestReader;

public class WindwardRequest
implements RequestReader {
    private String method;
    private String uri;
    private Boolean keepAlive;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>(16);
    private final Map<String, List<String>> querystring = new HashMap<String, List<String>>(16);
    private final Map<String, Object> pathVariables = new HashMap<String, Object>(16);
    private String requestBody;
    private final RequestReader requestReader = new DefaultRequestReader();

    public static WindwardRequestBuilder newBuild() {
        return new WindwardRequestBuilder(new WindwardRequest());
    }

    private WindwardRequest() {
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getHeader(String name) {
        if (!this.headers.containsKey(name)) {
            return Collections.emptyList();
        }
        return this.headers.get(name);
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, List<String>> getQuerystring() {
        return this.querystring;
    }

    public Map<String, Object> getPathVariables() {
        return this.pathVariables;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    @Override
    public <I> I readJson(String body, Class<I> clazz) {
        return this.requestReader.readJson(body, clazz);
    }

    @Override
    public <I> I readJson(String body, Type type) {
        return this.requestReader.readJson(body, type);
    }

    @Override
    public <I> I bindJson(String body, Class<I> clazz, Class<?> ... groups) {
        return this.requestReader.bindJson(body, clazz, groups);
    }

    @Override
    public <I> I bindJson(String body, Type type, Class<?> ... groups) {
        return this.requestReader.bindJson(body, type, groups);
    }

    public static class WindwardRequestBuilder {
        private final WindwardRequest windwardRequest;

        private WindwardRequestBuilder(WindwardRequest windwardRequest) {
            this.windwardRequest = windwardRequest;
        }

        public WindwardRequestBuilder method(String method) {
            this.windwardRequest.method = method;
            return this;
        }

        public WindwardRequestBuilder uri(String uri) {
            this.windwardRequest.uri = uri;
            return this;
        }

        public WindwardRequestBuilder keepAlive(Boolean keepAlive) {
            this.windwardRequest.keepAlive = keepAlive;
            return this;
        }

        public WindwardRequestBuilder headers(Map<String, List<String>> headers) {
            this.windwardRequest.headers.putAll(headers);
            return this;
        }

        public WindwardRequestBuilder querystring(Map<String, List<String>> querystring) {
            this.windwardRequest.querystring.putAll(querystring);
            return this;
        }

        public WindwardRequestBuilder pathVariables(Map<String, Object> pathVariables) {
            this.windwardRequest.pathVariables.putAll(pathVariables);
            return this;
        }

        public WindwardRequestBuilder requestBody(String requestBody) {
            this.windwardRequest.requestBody = requestBody;
            return this;
        }

        public WindwardRequest build() {
            return this.windwardRequest;
        }
    }
}

