/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.context;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.flmelody.core.HttpStatus;
import org.flmelody.core.MediaType;
import org.flmelody.core.Windward;
import org.flmelody.core.WindwardRequest;
import org.flmelody.core.WindwardResponse;
import org.flmelody.core.context.AbstractWindwardContext;
import org.flmelody.core.context.HttpBasicWindwardContext;
import org.flmelody.core.exception.WindwardException;
import org.flmelody.core.plugin.json.JsonPlugin;
import org.flmelody.core.plugin.view.AbstractViewPlugin;

public abstract class AbstractHttpWindwardContext
extends AbstractWindwardContext
implements HttpBasicWindwardContext {
    protected AbstractHttpWindwardContext(WindwardRequest windwardRequest, WindwardResponse windwardResponse) {
        super(windwardRequest, windwardResponse);
    }

    @Override
    public <I> I readJson(Class<I> clazz) {
        return this.windwardRequest.readJson(this.windwardRequest.getRequestBody(), clazz);
    }

    @Override
    public <I> I readJson(Type type) {
        return this.windwardRequest.readJson(this.windwardRequest.getRequestBody(), type);
    }

    @Override
    public <I> I bindJson(Class<I> clazz, Class<?> ... groups) {
        return this.windwardRequest.bindJson(this.windwardRequest.getRequestBody(), clazz, groups);
    }

    @Override
    public <I> I bindJson(Type type, Class<?> ... groups) {
        return this.windwardRequest.bindJson(this.windwardRequest.getRequestBody(), type, groups);
    }

    @Override
    public void redirect(String redirectUrl) {
        this.redirect(HttpStatus.FOUND.value(), redirectUrl);
    }

    @Override
    public void redirect(int code, String redirectUrl) {
        if (HttpStatus.MOVED_PERMANENTLY.value() == code || HttpStatus.FOUND.value() == code) {
            HashMap<String, Object> headerMap = new HashMap<String, Object>();
            headerMap.put("location", redirectUrl);
            this.windwardResponse.write(code, MediaType.TEXT_PLAIN_VALUE.value, headerMap, null);
            return;
        }
        throw new WindwardException("Illegal redirecting code" + code);
    }

    @Override
    public <M> void html(String viewUrl, M model) {
        if (viewUrl == null || viewUrl.isEmpty()) {
            throw new WindwardException("View name is empty!");
        }
        int i = viewUrl.lastIndexOf(".");
        if (i <= 0) {
            throw new WindwardException("Unknown View extension!");
        }
        String extension = viewUrl.substring(i + 1);
        Optional<AbstractViewPlugin> view = Windward.plugins(AbstractViewPlugin.class).stream().filter(viewPlugin -> viewPlugin.supportedExtension(extension)).findFirst();
        if (view.isPresent()) {
            AbstractViewPlugin viewPlugin2 = view.get();
            try {
                String renderedView = viewPlugin2.resolveView(viewUrl, (Map)Windward.plugin(JsonPlugin.class).toObject(model, (Type)((Object)HashMap.class)));
                this.windwardResponse.write(HttpStatus.OK.value(), MediaType.TEXT_HTML_VALUE.value, Collections.emptyMap(), renderedView);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new WindwardException("Unsupported View extension!");
        }
    }
}

