/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import org.flmelody.core.HttpServer;
import org.flmelody.core.exception.ServerException;
import org.flmelody.core.netty.handler.HttpServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpServer
implements HttpServer {
    private final int port;
    static Logger logger = LoggerFactory.getLogger(NettyHttpServer.class);

    public NettyHttpServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws ServerException {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new HttpServerCodec()});
                    p.addLast(new ChannelHandler[]{new CorsHandler(CorsConfigBuilder.forAnyOrigin().allowNullOrigin().allowCredentials().build())});
                    p.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    p.addLast(new ChannelHandler[]{new HttpServerHandler()});
                }
            });
            try {
                ChannelFuture f = b.bind(this.port).sync();
                logger.atInfo().log("Server started success on port {}", (Object)this.port);
                f.channel().closeFuture().sync();
            }
            catch (InterruptedException e) {
                logger.atInfo().log("Server run error", (Object)e);
                Thread.currentThread().interrupt();
                throw new ServerException("Server run error");
            }
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
            logger.atInfo().log("Server shutdown");
        }
    }
}

