/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.flmelody.core.MediaType;
import org.flmelody.core.ResponseWriter;
import org.flmelody.core.Windward;
import org.flmelody.core.plugin.json.JsonPlugin;

public class NettyResponseWriter
implements ResponseWriter {
    private final ChannelHandlerContext ctx;
    private final boolean keepConnection;

    public NettyResponseWriter(ChannelHandlerContext ctx, boolean keepConnection) {
        this.ctx = ctx;
        this.keepConnection = keepConnection;
    }

    @Override
    public <T> void write(int code, T data) {
        this.write(code, MediaType.APPLICATION_JSON_VALUE.value, data);
    }

    @Override
    public <T> void write(int code, String contentType, T data) {
        this.write(code, contentType, data, !this.keepConnection);
    }

    @Override
    public <T> void write(int code, String contentType, Map<String, Object> headers, T data) {
        this.write(code, contentType, headers, data, !this.keepConnection);
    }

    @Override
    public <T> void write(int code, String contentType, T data, boolean close) {
        this.write(code, contentType, Collections.emptyMap(), data, close);
    }

    @Override
    public <T> void write(int code, String contentType, Map<String, Object> headers, T data, boolean close) {
        Channel channel = this.ctx.channel();
        if (!channel.isActive()) {
            return;
        }
        ByteBuf response = data == null ? Unpooled.EMPTY_BUFFER : (MediaType.APPLICATION_JSON_VALUE.value.equals(contentType) ? Unpooled.copiedBuffer((CharSequence)Windward.plugin(JsonPlugin.class).toJson(data), (Charset)CharsetUtil.UTF_8) : Unpooled.copiedBuffer((CharSequence)String.valueOf(data), (Charset)CharsetUtil.UTF_8));
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, response);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        httpResponse.setStatus(HttpResponseStatus.valueOf((int)code));
        if (headers != null && !headers.isEmpty()) {
            headers.keySet().forEach(arg_0 -> NettyResponseWriter.lambda$write$0((FullHttpResponse)httpResponse, headers, arg_0));
        }
        if (!close) {
            httpResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, httpResponse.content().readableBytes());
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        this.ctx.writeAndFlush((Object)httpResponse);
        if (close) {
            this.close();
        }
    }

    @Override
    public <T> void writeAndClose(int code, String contentType, T data) {
        this.write(code, contentType, data, Boolean.TRUE);
    }

    @Override
    public void close() {
        if (this.ctx.channel().isActive()) {
            this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static /* synthetic */ void lambda$write$0(FullHttpResponse httpResponse, Map headers, String key) {
        httpResponse.headers().set(key, headers.get(key));
    }
}

