/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.flmelody.core.HttpStatus;
import org.flmelody.core.MediaType;
import org.flmelody.core.WindwardRequest;
import org.flmelody.core.context.WindwardContext;
import org.flmelody.core.exception.HandlerNotFoundException;
import org.flmelody.core.exception.WindwardException;
import org.flmelody.core.plugin.resource.ResourcePlugin;
import org.flmelody.util.UrlUtil;

public class BaseStaticResourcePlugin
implements ResourcePlugin,
Consumer<WindwardContext> {
    protected final String[] staticResourceLocations;

    public BaseStaticResourcePlugin(String[] staticResourceLocations) {
        this.staticResourceLocations = staticResourceLocations;
    }

    @Override
    public void accept(WindwardContext windwardContext) {
        String mimeType;
        WindwardRequest windwardRequest = windwardContext.windwardRequest();
        String fileUri = windwardRequest.getUri();
        String resource = this.findResource(fileUri);
        Path path = new File(fileUri).toPath();
        try {
            mimeType = Files.probeContentType(path);
        }
        catch (IOException e) {
            throw new WindwardException(e);
        }
        windwardContext.write(HttpStatus.OK.value(), MediaType.detectMediaType((String)mimeType).value, resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String findResource(String fileUri) {
        String[] stringArray = this.staticResourceLocations;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String staticResourceLocation = stringArray[n2];
            if (!fileUri.startsWith(staticResourceLocation)) {
                fileUri = UrlUtil.buildUrl(staticResourceLocation, fileUri);
            }
            try (InputStream in = this.getClass().getResourceAsStream(fileUri);){
                if (in != null && !(in instanceof ByteArrayInputStream)) {
                    String string = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    return string;
                }
            }
            catch (IOException e) {
                throw new WindwardException(e);
            }
            ++n2;
        }
        throw new HandlerNotFoundException("No matched resource!");
    }
}

