/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.resource;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.flmelody.core.context.WindwardContext;
import org.flmelody.core.exception.HandlerNotFoundException;
import org.flmelody.core.plugin.resource.BaseStaticResourcePlugin;
import org.flmelody.util.UrlUtil;

public class FixedStaticResourcePlugin
extends BaseStaticResourcePlugin {
    private final Set<String> fixedPages = new HashSet<String>(Collections.singletonList("index.html"));

    public FixedStaticResourcePlugin(String[] staticResourceLocations) {
        super(staticResourceLocations);
    }

    public void appendPages(String ... pageNames) {
        if (pageNames != null) {
            this.fixedPages.addAll(Arrays.asList(pageNames));
        }
    }

    @Override
    public void accept(WindwardContext windwardContext) {
        super.accept(windwardContext);
    }

    @Override
    protected String findResource(String fileUri) {
        try {
            return super.findResource(fileUri);
        }
        catch (HandlerNotFoundException e) {
            for (String fixedPage : this.fixedPages) {
                if (fileUri.endsWith(fixedPage)) {
                    throw e;
                }
                int index = fileUri.lastIndexOf("/");
                if (index < 0) {
                    try {
                        return super.findResource(fixedPage);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    String spa = UrlUtil.buildUrl(fileUri, fixedPage);
                    return super.findResource(spa);
                }
                catch (Exception exception) {
                }
            }
            throw new HandlerNotFoundException("No matched resource!");
        }
    }
}

