/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core;

import java.util.Map;
import org.flmelody.core.context.WindwardContext;
import org.flmelody.core.exception.WindwardException;
import org.flmelody.support.EnhancedFunction;
import org.flmelody.support.FunctionDefinition;
import org.flmelody.support.FunctionHelper;

public class FunctionMetaInfo<I> {
    private final String path;
    private final I function;
    private final Class<? extends WindwardContext> context;
    private final Class<? extends WindwardContext> parameterType;
    private final Class<?> resultType;
    private final Map<String, Object> pathVariables;
    private final FunctionDefinition functionDefinition;

    public FunctionMetaInfo(String path, I function, Class<? extends WindwardContext> context, Map<String, Object> pathVariables) {
        this.path = path;
        this.function = function;
        this.context = context;
        this.pathVariables = pathVariables;
        if (function instanceof EnhancedFunction) {
            EnhancedFunction enhancedFunction = (EnhancedFunction)function;
            FunctionDefinition functionDefinition = FunctionHelper.resolveFunction(enhancedFunction);
            if (functionDefinition.getParameterTypes().isEmpty()) {
                throw new WindwardException("Illegal function!");
            }
            this.parameterType = (Class)functionDefinition.getParameterTypes().stream().findFirst().orElseThrow(() -> new WindwardException("Missed parameter type!"));
            this.resultType = functionDefinition.getReturnType();
            this.functionDefinition = functionDefinition;
        } else {
            this.functionDefinition = FunctionDefinition.empty();
            this.parameterType = null;
            this.resultType = null;
        }
    }

    public String getPath() {
        return this.path;
    }

    public I getFunction() {
        return this.function;
    }

    public Class<? extends WindwardContext> getContext() {
        return this.context;
    }

    public Class<? extends WindwardContext> getParameterType() {
        return this.parameterType;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public Map<String, Object> getPathVariables() {
        return this.pathVariables;
    }

    public FunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }
}

