/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.flmelody.core.AbstractRouterGroup;
import org.flmelody.core.DefaultNotFoundHandler;
import org.flmelody.core.DefaultRouterGroup;
import org.flmelody.core.ExceptionHandler;
import org.flmelody.core.Filter;
import org.flmelody.core.FunctionMetaInfo;
import org.flmelody.core.HttpMethod;
import org.flmelody.core.HttpServer;
import org.flmelody.core.LoggingFilter;
import org.flmelody.core.Order;
import org.flmelody.core.Router;
import org.flmelody.core.RouterGroup;
import org.flmelody.core.context.EnhancedWindwardContext;
import org.flmelody.core.context.SimpleWindwardContext;
import org.flmelody.core.exception.PluginMissException;
import org.flmelody.core.exception.ServerException;
import org.flmelody.core.netty.NettyHttpServer;
import org.flmelody.core.plugin.Plugin;
import org.flmelody.core.plugin.PluginSlot;
import org.flmelody.core.plugin.json.AutoJsonBinder;
import org.flmelody.core.plugin.resolver.CompositePluginResolver;
import org.flmelody.core.plugin.resolver.PluginResolver;
import org.flmelody.core.plugin.resource.BaseStaticResourcePlugin;
import org.flmelody.core.plugin.view.ViewEngineDetector;
import org.flmelody.core.plugin.view.freemarker.FreemarkerView;
import org.flmelody.core.plugin.view.groovy.GroovyView;
import org.flmelody.core.plugin.view.thymeleaf.ThymeleafView;
import org.flmelody.core.sse.SseEjector;
import org.flmelody.core.sse.SseWindwardContext;
import org.flmelody.core.wind.DefaultWindManager;
import org.flmelody.core.wind.WindManager;
import org.flmelody.core.wind.event.Event;
import org.flmelody.core.wind.listener.Listener;
import org.flmelody.core.ws.WebSocketWindwardContext;
import org.flmelody.support.EnhancedFunction;
import org.flmelody.util.UrlUtil;

public final class Windward
implements Router<Windward> {
    private static final List<AbstractRouterGroup<Windward>> routerGroups = new ArrayList<AbstractRouterGroup<Windward>>();
    private static final List<AbstractRouterGroup<Windward>> resourceRouterGroups = new ArrayList<AbstractRouterGroup<Windward>>();
    private static final List<Filter> globalFilters = new ArrayList<Filter>();
    private static final List<ExceptionHandler> globalExceptionHandlers = new ArrayList<ExceptionHandler>();
    private static final Map<Class<?>, Plugin> globalPlugins = new HashMap();
    private final String contextPath;
    private final String templateRoot;
    private final String staticResourceLocation;
    private final PluginResolver pluginResolver = new CompositePluginResolver();
    private final WindManager windManager = new DefaultWindManager(this);
    private HttpServer httpServer;

    private Windward(String contextPath, String templateRoot, String staticResourceLocation) {
        this.contextPath = contextPath;
        this.templateRoot = templateRoot;
        this.staticResourceLocation = staticResourceLocation;
    }

    public static Windward setup() {
        return Windward.setup(8080, new LoggingFilter());
    }

    public static Windward setup(int port, Filter ... filters) {
        return Windward.setup(port, "/", filters);
    }

    public static Windward setup(int port, String contextPath, Filter ... filters) {
        return Windward.setup(port, contextPath, "/templates", "/static", filters);
    }

    public static Windward setup(int port, String contextPath, String templateRoot, String staticResourceLocation, Filter ... filters) {
        Windward windward = new Windward(contextPath, templateRoot, staticResourceLocation);
        windward.httpServer = new NettyHttpServer(port);
        windward.registerExceptionHandler(new DefaultNotFoundHandler()).registerFilter(filters).registerPlugin(PluginSlot.JSON, (Plugin)AutoJsonBinder.jsonPlugin).registerPlugin(PluginSlot.RESOURCE, (Plugin)new BaseStaticResourcePlugin());
        return Windward.prepareDefault(windward);
    }

    private static Windward prepareDefault(Windward windward) {
        if (ViewEngineDetector.AVAILABLE_GROOVY_ENGINE) {
            windward.registerPlugin(PluginSlot.GROOVY_VIEW, (Plugin)new GroovyView());
        }
        if (ViewEngineDetector.AVAILABLE_THYMELEAF_ENGINE) {
            windward.registerPlugin(PluginSlot.THYMELEAF_VIEW, (Plugin)new ThymeleafView());
        }
        if (ViewEngineDetector.AVAILABLE_FREEMARKER_ENGINE) {
            windward.registerPlugin(PluginSlot.FREEMARKER_VIEW, (Plugin)new FreemarkerView());
        }
        return windward;
    }

    private void beforeStart() {
        this.windManager.triggerEvent();
    }

    public void run() throws ServerException {
        this.beforeStart();
        this.httpServer.run();
    }

    public RouterGroup<Windward> group(String relativePath) {
        DefaultRouterGroup defaultRouterGroup = new DefaultRouterGroup(this, UrlUtil.buildUrl(this.contextPath, relativePath));
        routerGroups.add(defaultRouterGroup);
        return defaultRouterGroup;
    }

    private RouterGroup<Windward> resourceGroup(String relativePath) {
        DefaultRouterGroup defaultRouterGroup = new DefaultRouterGroup(this, UrlUtil.buildUrl(this.contextPath, relativePath), true);
        resourceRouterGroups.add(defaultRouterGroup);
        return defaultRouterGroup;
    }

    public Windward registerFilter(Filter ... filters) {
        if (filters == null || filters.length == 0) {
            return this;
        }
        globalFilters.addAll(Arrays.asList(filters));
        return this;
    }

    public Windward registerExceptionHandler(ExceptionHandler ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this;
        }
        globalExceptionHandlers.addAll(Arrays.asList(exceptionHandlers));
        globalExceptionHandlers.sort(Comparator.comparingInt(Order::getOrder));
        return this;
    }

    public Windward registerListener(Listener ... listeners) {
        if (listeners == null) {
            return this;
        }
        for (Listener listener : listeners) {
            this.windManager.join(listener);
        }
        return this;
    }

    public Windward registerPlugin(PluginSlot pluginSlot, Plugin plugin) {
        return this.registerPlugin(pluginSlot.clazz, plugin);
    }

    private Windward registerPlugin(Class<? extends Plugin> clazz, Plugin plugin) {
        this.pluginResolver.resolve(this, plugin);
        PluginSlot slot = PluginSlot.slot(clazz);
        if (PluginSlot.ANY.equals((Object)slot)) {
            globalPlugins.put(clazz, plugin);
        } else {
            globalPlugins.put(slot.clazz, plugin);
        }
        return this;
    }

    public Windward publishEvent(Event ... events) {
        if (events == null) {
            return this;
        }
        for (Event event : events) {
            this.windManager.loadEvent(event);
        }
        return this;
    }

    public static <I> FunctionMetaInfo<I> findRouter(String relativePath, String method) {
        FunctionMetaInfo functionMetaInfo;
        for (AbstractRouterGroup<Windward> routerGroup : routerGroups) {
            functionMetaInfo = (FunctionMetaInfo)routerGroup.matchRouter(relativePath, method);
            if (functionMetaInfo == null) continue;
            return functionMetaInfo;
        }
        for (AbstractRouterGroup<Windward> routerGroup : resourceRouterGroups) {
            functionMetaInfo = (FunctionMetaInfo)routerGroup.matchRouter(relativePath, method);
            if (functionMetaInfo == null) continue;
            return functionMetaInfo;
        }
        return null;
    }

    public static List<Filter> filters() {
        return Collections.unmodifiableList(globalFilters);
    }

    public static List<ExceptionHandler> exceptionHandlers() {
        return Collections.unmodifiableList(globalExceptionHandlers);
    }

    public static <T extends Plugin> T plugin(Class<T> clazz) {
        if (!globalPlugins.containsKey(clazz)) {
            throw new PluginMissException(String.format("Plugin [%s] not found", clazz.getName()));
        }
        return (T)globalPlugins.get(clazz);
    }

    public static <T extends Plugin> List<T> plugins(Class<T> clazz) {
        return globalPlugins.values().stream().filter(plugin -> clazz.isAssignableFrom(plugin.getClass())).map(plugin -> plugin).collect(Collectors.toList());
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getTemplateRoot() {
        return this.templateRoot;
    }

    public String getStaticResourceLocation() {
        return this.staticResourceLocation;
    }

    public Windward then() {
        return this;
    }

    @Override
    public <R> Windward http(HttpMethod httpMethod, String relativePath, Supplier<R> supplier) {
        this.group("/").http(httpMethod, relativePath, supplier);
        return this;
    }

    @Override
    public Windward http(HttpMethod httpMethod, String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.group("/").http(httpMethod, relativePath, consumer);
        return this;
    }

    @Override
    public <C extends EnhancedWindwardContext> Windward http(HttpMethod httpMethod, String relativePath, EnhancedFunction<C, ?> function) {
        this.group("/").http(httpMethod, relativePath, function);
        return this;
    }

    @Override
    public <R> Windward get(String relativePath, Supplier<R> supplier) {
        this.group("/").get(relativePath, supplier);
        return this;
    }

    @Override
    public Windward get(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.group("/").get(relativePath, consumer);
        return this;
    }

    @Override
    public <C extends EnhancedWindwardContext> Windward get(String relativePath, EnhancedFunction<C, ?> function) {
        this.group("/").get(relativePath, function);
        return this;
    }

    @Override
    public <R> Windward put(String relativePath, Supplier<R> supplier) {
        this.group("/").put(relativePath, supplier);
        return this;
    }

    @Override
    public Windward put(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.group("/").put(relativePath, consumer);
        return this;
    }

    @Override
    public <C extends EnhancedWindwardContext> Windward put(String relativePath, EnhancedFunction<C, ?> function) {
        this.group("/").put(relativePath, function);
        return this;
    }

    @Override
    public <R> Windward post(String relativePath, Supplier<R> supplier) {
        this.group("/").post(relativePath, supplier);
        return this;
    }

    @Override
    public Windward post(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.group("/").post(relativePath, consumer);
        return this;
    }

    @Override
    public <C extends EnhancedWindwardContext> Windward post(String relativePath, EnhancedFunction<C, ?> function) {
        this.group("/").post(relativePath, function);
        return this;
    }

    @Override
    public <R> Windward delete(String relativePath, Supplier<R> supplier) {
        this.group("/").delete(relativePath, supplier);
        return this;
    }

    @Override
    public Windward delete(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.group("/").delete(relativePath, consumer);
        return this;
    }

    @Override
    public <C extends EnhancedWindwardContext> Windward delete(String relativePath, EnhancedFunction<C, ?> function) {
        this.group("/").delete(relativePath, function);
        return this;
    }

    @Override
    public Windward sse(String relativePath, EnhancedFunction<SseWindwardContext, SseEjector> function) {
        this.group("/").sse(relativePath, function);
        return this;
    }

    @Override
    public Windward sse(HttpMethod httpMethod, String relativePath, EnhancedFunction<SseWindwardContext, SseEjector> function) {
        this.group("/").sse(httpMethod, relativePath, function);
        return this;
    }

    @Override
    public Windward ws(String relativePath, Consumer<WebSocketWindwardContext> consumer) {
        this.group("/").ws(relativePath, consumer);
        return this;
    }

    @Override
    public Windward resource(String ... pathPatterns) {
        return this.resources(this.staticResourceLocation, pathPatterns);
    }

    @Override
    public Windward resources(String staticResourceLocation, String ... pathPatterns) {
        this.resourceGroup("/").resources(staticResourceLocation, pathPatterns);
        return this;
    }
}

