/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.context;

import java.util.List;
import java.util.Map;
import org.flmelody.core.HttpStatus;
import org.flmelody.core.MediaType;
import org.flmelody.core.WindwardRequest;
import org.flmelody.core.WindwardResponse;
import org.flmelody.core.context.WindwardContext;

public abstract class AbstractWindwardContext
implements WindwardContext {
    protected final WindwardRequest windwardRequest;
    protected final WindwardResponse windwardResponse;
    private Boolean closed = Boolean.FALSE;

    protected AbstractWindwardContext(WindwardRequest windwardRequest, WindwardResponse windwardResponse) {
        this.windwardRequest = windwardRequest;
        this.windwardResponse = windwardResponse;
    }

    @Override
    public <P> P getRequestParameter(String parameterName) {
        List<String> parameters = this.windwardRequest.getQuerystring().get(parameterName);
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        return (P)parameters.get(0);
    }

    @Override
    public List<String> getRequestParameters(String parameterName) {
        return this.windwardRequest.getQuerystring().get(parameterName);
    }

    @Override
    public Map<String, Object> getPathVariables() {
        return this.windwardRequest.getPathVariables();
    }

    @Override
    public String getRequestBody() {
        return this.windwardRequest.getRequestBody();
    }

    @Override
    public WindwardRequest windwardRequest() {
        return this.windwardRequest;
    }

    @Override
    public void close() {
        this.closed = Boolean.TRUE;
        this.windwardResponse.close();
    }

    @Override
    public Boolean isClosed() {
        return this.closed;
    }

    @Override
    public <T> void writeJson(T data) {
        this.writeJson(HttpStatus.OK.value(), data);
    }

    @Override
    public <T> void writeJson(int code, T data) {
        this.write(code, MediaType.APPLICATION_JSON_VALUE.value, data);
    }

    @Override
    public void writeString(String data) {
        this.writeString(HttpStatus.OK.value(), data);
    }

    @Override
    public void writeString(int code, String data) {
        this.write(code, MediaType.TEXT_PLAIN_VALUE.value, data);
    }

    @Override
    public <T> void write(String contentType, T data) {
        this.write(HttpStatus.OK.value(), contentType, data);
    }

    @Override
    public <T> void write(int code, String contentType, T data) {
        this.windwardResponse.write(code, contentType, data);
    }
}

