/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.flmelody.core.ExceptionHandler;
import org.flmelody.core.Filter;
import org.flmelody.core.FunctionMetaInfo;
import org.flmelody.core.HttpStatus;
import org.flmelody.core.Windward;
import org.flmelody.core.WindwardRequest;
import org.flmelody.core.WindwardResponse;
import org.flmelody.core.context.EmptyWindwardContext;
import org.flmelody.core.context.EnhancedWindwardContext;
import org.flmelody.core.context.ResourceWindwardContext;
import org.flmelody.core.context.SimpleWindwardContext;
import org.flmelody.core.context.WindwardContext;
import org.flmelody.core.context.support.DelayContext;
import org.flmelody.core.exception.HandlerNotFoundException;
import org.flmelody.core.netty.NettyResponseWriter;
import org.flmelody.core.netty.handler.SocketTailHandler;
import org.flmelody.core.netty.handler.WebSocketHandler;
import org.flmelody.core.plugin.ws.ExtensionalWebSocketPlugin;
import org.flmelody.core.support.HttpRequestHolder;
import org.flmelody.core.ws.WebSocketEvent;
import org.flmelody.core.ws.WebSocketFireEvent;
import org.flmelody.core.ws.WebSocketParser;
import org.flmelody.core.ws.WebSocketWindwardContext;
import org.flmelody.core.ws.codec.WebSocketCodec;
import org.flmelody.support.EnhancedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerHandler.class);
    private WindwardContext cachedWindwardContext;
    private FunctionMetaInfo<?> cachedFunctionMetaInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)msg;
            String uri = fullHttpRequest.uri().split("\\?")[0];
            FunctionMetaInfo functionMetaInfo = Windward.findRouter(uri, fullHttpRequest.method().name());
            WindwardContext windwardContext = this.cachedWindwardContext;
            if (windwardContext == null && (windwardContext = this.initContext(ctx, fullHttpRequest, functionMetaInfo)).isCacheable().booleanValue()) {
                this.cachedWindwardContext = windwardContext;
                this.cachedFunctionMetaInfo = functionMetaInfo;
            }
            if (HttpServerHandler.isWebsocketUpgrade(fullHttpRequest.headers()) && this.cachedWindwardContext != null) {
                ctx.pipeline().addBefore(ctx.name(), WebSocketServerCompressionHandler.class.getSimpleName(), (ChannelHandler)new WebSocketServerCompressionHandler());
                ctx.pipeline().addBefore(ctx.name(), WebSocketHandler.class.getSimpleName(), (ChannelHandler)new WebSocketHandler());
                ctx.pipeline().addAfter(ctx.name(), WebSocketServerProtocolHandler.class.getSimpleName(), (ChannelHandler)new WebSocketServerProtocolHandler(fullHttpRequest.uri(), null, true));
                this.extractHandlers(ctx, uri);
                ctx.pipeline().addLast(new ChannelHandler[]{new SocketTailHandler()});
                ctx.fireChannelRead((Object)fullHttpRequest.retain());
                return;
            }
            if (this.cachedWindwardContext != null && this.cachedWindwardContext instanceof WebSocketWindwardContext) {
                WebSocketWindwardContext websocketWindwardContext = (WebSocketWindwardContext)this.cachedWindwardContext;
                websocketWindwardContext.setHttpResponse(true);
            }
            try {
                HttpRequestHolder.setContext(windwardContext);
                this.handle(functionMetaInfo, windwardContext);
            }
            finally {
                WindwardContext context = HttpRequestHolder.getContext();
                if (!(context instanceof DelayContext)) {
                    HttpRequestHolder.resetContext();
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof WebSocketFireEvent && this.cachedWindwardContext instanceof WebSocketWindwardContext) {
            WebSocketFireEvent webSocketFireEvent = (WebSocketFireEvent)evt;
            WebSocketWindwardContext websocketWindwardContext = (WebSocketWindwardContext)this.cachedWindwardContext;
            websocketWindwardContext.setWebSocketEvent(webSocketFireEvent.getEvent());
            websocketWindwardContext.setWebSocketData(webSocketFireEvent.getData());
            this.handle(this.cachedFunctionMetaInfo, websocketWindwardContext);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (this.cachedWindwardContext instanceof WebSocketWindwardContext) {
                WebSocketWindwardContext webSocketWindwardContext = (WebSocketWindwardContext)this.cachedWindwardContext;
                webSocketWindwardContext.setWebSocketEvent(WebSocketEvent.ON_CLOSE);
                webSocketWindwardContext.setWebSocketData(null);
                this.handle(this.cachedFunctionMetaInfo, webSocketWindwardContext);
            }
        }));
    }

    private void extractHandlers(ChannelHandlerContext ctx, String uri) {
        List<ExtensionalWebSocketPlugin> plugins = Windward.plugins(ExtensionalWebSocketPlugin.class);
        for (ExtensionalWebSocketPlugin plugin : plugins) {
            boolean emptyParsers;
            if (!plugin.isMatch(uri)) continue;
            List<WebSocketCodec> webSocketCodecs = plugin.getWebSocketCodecs();
            List<WebSocketParser<?>> webSocketParsers = plugin.getWebSocketParsers();
            boolean emptyCodecs = webSocketCodecs == null || webSocketCodecs.isEmpty();
            boolean bl = emptyParsers = webSocketParsers == null || webSocketParsers.isEmpty();
            if (emptyCodecs && emptyParsers) continue;
            if (!emptyCodecs) {
                ctx.pipeline().addLast((ChannelHandler[])webSocketCodecs.toArray(new WebSocketCodec[0]));
            }
            if (!emptyParsers) {
                ctx.pipeline().addLast((ChannelHandler[])webSocketParsers.toArray(new WebSocketParser[0]));
            }
            ctx.channel().attr(WebSocketHandler.MULTIPLE_SUBSCRIBER).set((Object)true);
            break;
        }
    }

    private Map<String, List<String>> prepareHeaders(HttpHeaders httpHeaders) {
        Iterator entryIterator = httpHeaders.iteratorAsString();
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        while (entryIterator.hasNext()) {
            Map.Entry next = (Map.Entry)entryIterator.next();
            if (headers.containsKey(next.getKey())) {
                ((List)headers.get(next.getKey())).add(next.getValue());
                continue;
            }
            ArrayList values = new ArrayList();
            values.add(next.getValue());
            headers.put((String)next.getKey(), values);
        }
        return headers;
    }

    private <I> WindwardContext initContext(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest, FunctionMetaInfo<I> functionMetaInfo) {
        String uri = fullHttpRequest.uri();
        ByteBuf content = fullHttpRequest.content();
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        Map params = queryStringDecoder.parameters();
        uri = uri.split("\\?")[0];
        WindwardRequest.WindwardRequestBuilder windwardRequestBuilder = WindwardRequest.newBuild().headers(this.prepareHeaders(fullHttpRequest.headers())).method(fullHttpRequest.method().name()).uri(uri).keepAlive(keepAlive).querystring(params);
        if (content.isReadable()) {
            String string = content.toString(CharsetUtil.UTF_8);
            windwardRequestBuilder.requestBody(string);
        }
        WindwardResponse.WindwardResponseBuild windwardResponseBuild = WindwardResponse.newBuilder().responseWriter(new NettyResponseWriter(ctx, keepAlive));
        if (functionMetaInfo == null) {
            return new SimpleWindwardContext(windwardRequestBuilder.build(), windwardResponseBuild.build());
        }
        try {
            Class<WindwardContext> context = functionMetaInfo.getContext();
            if (context.isAssignableFrom(SimpleWindwardContext.class)) {
                return new SimpleWindwardContext(windwardRequestBuilder.pathVariables(functionMetaInfo.getPathVariables()).build(), windwardResponseBuild.build());
            }
            if (EnhancedWindwardContext.class.isAssignableFrom(context)) {
                Class<WindwardContext> parameterType = functionMetaInfo.getParameterType();
                return parameterType.getConstructor(WindwardRequest.class, WindwardResponse.class).newInstance(windwardRequestBuilder.pathVariables(functionMetaInfo.getPathVariables()).build(), windwardResponseBuild.build());
            }
            if (context.isAssignableFrom(WebSocketWindwardContext.class)) {
                return new WebSocketWindwardContext(windwardRequestBuilder.pathVariables(functionMetaInfo.getPathVariables()).build(), windwardResponseBuild.build());
            }
            if (context.isAssignableFrom(ResourceWindwardContext.class)) {
                return new ResourceWindwardContext(windwardRequestBuilder.pathVariables(functionMetaInfo.getPathVariables()).build(), windwardResponseBuild.build(), functionMetaInfo.getPath());
            }
        }
        catch (Exception e) {
            logger.atError().log("Failed to construct context");
        }
        return new EmptyWindwardContext();
    }

    private void handle(FunctionMetaInfo<?> functionMetaInfo, WindwardContext windwardContext) {
        if (windwardContext.isClosed().booleanValue()) {
            return;
        }
        for (Filter filter : Windward.filters()) {
            try {
                filter.filter(windwardContext);
            }
            catch (Exception e) {
                logger.atError().log("Handler error", (Object)e);
                windwardContext.writeString(HttpStatus.INTERNAL_SERVER_ERROR.value(), HttpStatus.INTERNAL_SERVER_ERROR.reasonPhrase());
                windwardContext.close();
                return;
            }
        }
        this.execute(functionMetaInfo, windwardContext);
    }

    private void execute(FunctionMetaInfo<?> functionMetaInfo, WindwardContext windwardContext) {
        block8: {
            try {
                if (functionMetaInfo == null) {
                    throw new HandlerNotFoundException("No handler found!");
                }
                Object function = functionMetaInfo.getFunction();
                if (function instanceof Consumer) {
                    Consumer contextConsumer = (Consumer)function;
                    contextConsumer.accept(windwardContext);
                    break block8;
                }
                if (function instanceof EnhancedFunction) {
                    EnhancedWindwardContext enhancedWindwardContext = (EnhancedWindwardContext)windwardContext;
                    enhancedWindwardContext.execute((EnhancedFunction)function);
                    break block8;
                }
                if (function instanceof Supplier) {
                    Supplier supplier = (Supplier)function;
                    Object object = supplier.get();
                    if (object instanceof Serializable && !(object instanceof String)) {
                        windwardContext.writeJson(object);
                    } else {
                        windwardContext.writeString(object.toString());
                    }
                    break block8;
                }
                throw new HandlerNotFoundException("No handler found!");
            }
            catch (Exception e) {
                if (this.handleException(windwardContext, e)) break block8;
                logger.atError().log("Error occurred", (Object)e);
                windwardContext.writeString(HttpStatus.INTERNAL_SERVER_ERROR.value(), HttpStatus.INTERNAL_SERVER_ERROR.reasonPhrase());
            }
        }
    }

    private boolean handleException(WindwardContext windwardContext, Exception e) {
        List<ExceptionHandler> exceptionHandlers = Windward.exceptionHandlers();
        boolean alreadyDone = false;
        for (ExceptionHandler exceptionHandler : exceptionHandlers) {
            try {
                if (!exceptionHandler.supported(e)) continue;
                exceptionHandler.handle(windwardContext);
                alreadyDone = true;
                break;
            }
            catch (Exception exception) {
                logger.atError().log("Handle exception error", (Object)e);
            }
        }
        return alreadyDone;
    }

    private static boolean isWebsocketUpgrade(HttpHeaders headers) {
        return headers.contains((CharSequence)HttpHeaderNames.UPGRADE) && headers.containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && headers.contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }
}

