/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.sse;

import org.flmelody.core.sse.SseEvent;

public final class SseEventSource
implements SseEvent {
    private StringBuilder sb;

    private SseEventSource() {
    }

    private SseEventSource append(String text) {
        if (this.sb == null) {
            this.sb = new StringBuilder();
        }
        this.sb.append(text);
        return this;
    }

    public static SseEventSourceBuilder builder() {
        return new SseEventSourceBuilder(new SseEventSource());
    }

    @Override
    public SseEventSource id(String id) {
        this.append("id: ").append(id != null ? id : "").append("\n");
        return this;
    }

    @Override
    public SseEventSource name(String eventName) {
        this.append("event: ").append(eventName != null ? eventName : "").append("\n");
        return this;
    }

    @Override
    public SseEventSource reconnectTime(long reconnectTimeMillis) {
        this.append("retry: ").append(String.valueOf(reconnectTimeMillis)).append("\n");
        return this;
    }

    @Override
    public SseEventSource comment(String comment) {
        this.append(": ").append(comment != null ? comment : "").append("\n");
        return this;
    }

    @Override
    public SseEventSource data(String object) {
        if (object != null) {
            this.append("data: ").append(object).append("\n");
        }
        return this;
    }

    public static class SseEventSourceBuilder
    implements SseEvent {
        private final SseEventSource sseEventSource;

        private SseEventSourceBuilder(SseEventSource sseEventSource) {
            this.sseEventSource = sseEventSource;
        }

        @Override
        public SseEventSourceBuilder id(String id) {
            this.sseEventSource.id(id);
            return this;
        }

        @Override
        public SseEventSourceBuilder name(String eventName) {
            this.sseEventSource.name(eventName);
            return this;
        }

        @Override
        public SseEventSourceBuilder reconnectTime(long reconnectTimeMillis) {
            this.sseEventSource.reconnectTime(reconnectTimeMillis);
            return this;
        }

        @Override
        public SseEventSourceBuilder comment(String comment) {
            this.sseEventSource.comment(comment);
            return this;
        }

        @Override
        public SseEventSourceBuilder data(String object) {
            this.sseEventSource.data(object);
            return this;
        }

        public String build() {
            StringBuilder stringBuilder = this.sseEventSource.sb;
            if (stringBuilder != null) {
                String res = stringBuilder.append("\n").toString();
                this.sseEventSource.sb = null;
                return res;
            }
            return null;
        }
    }
}

