/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.sse;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.flmelody.core.HttpStatus;
import org.flmelody.core.MediaType;
import org.flmelody.core.Windward;
import org.flmelody.core.WindwardRequest;
import org.flmelody.core.WindwardResponse;
import org.flmelody.core.context.EnhancedWindwardContext;
import org.flmelody.core.context.support.DelayContext;
import org.flmelody.core.context.support.HttpKind;
import org.flmelody.core.plugin.json.JsonPlugin;
import org.flmelody.core.sse.SseChunkTail;
import org.flmelody.core.sse.SseEjector;
import org.flmelody.core.sse.SseEventSource;

public final class SseWindwardContext
extends EnhancedWindwardContext
implements DelayContext,
HttpKind {
    private static final Map<String, Object> headers = new HashMap<String, Object>();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10);
    private ScheduledFuture<?> scheduledFuture;

    public SseWindwardContext(WindwardRequest windwardRequest, WindwardResponse windwardResponse) {
        super(windwardRequest, windwardResponse);
    }

    @Override
    protected void doOnRequest() {
    }

    @Override
    protected <R> void doOnResponse(R r) {
        if (r instanceof SseEjector) {
            SseEjector sseEjector = (SseEjector)r;
            if (sseEjector.getTimeout() == 0L) {
                this.complete();
            } else {
                this.scheduledFuture = scheduler.schedule(sseEjector.getCallback(), sseEjector.getTimeout(), TimeUnit.SECONDS);
            }
        }
    }

    <T> void send(T data) {
        this.windwardResponse.write(HttpStatus.OK.value(), MediaType.TEXT_EVENT_STREAM_VALUE.value, headers, data);
    }

    void complete() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(true);
        }
        this.windwardResponse.write(HttpStatus.OK.value(), MediaType.TEXT_EVENT_STREAM_VALUE.value, headers, SseChunkTail.SSE_CHUNK_TAIL);
    }

    @Override
    public void redirect(int code, String redirectUrl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <M> void html(String viewUrl, M model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void write(int code, String contentType, T data) {
        if (data instanceof SseEventSource.SseEventSourceBuilder) {
            this.send(((SseEventSource.SseEventSourceBuilder)data).build());
        } else {
            this.send(SseEventSource.builder().data(Windward.plugin(JsonPlugin.class).toJson(data)).build());
        }
    }

    @Override
    public void destroy() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(true);
        }
        this.close();
    }

    static {
        headers.put("Cache-Control", "no-cache");
        headers.put("Connection", "keep-alive");
        headers.put("Transfer-Encoding", "chunked");
    }
}

