/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.context.support;

import org.flmelody.core.MediaType;
import org.flmelody.core.WindwardRequest;
import org.flmelody.core.WindwardResponse;
import org.flmelody.core.context.EnhancedWindwardContext;
import org.flmelody.core.context.support.HttpKind;
import org.flmelody.core.exception.ValidationException;

public class JsonWindwardContext
extends EnhancedWindwardContext
implements HttpKind {
    public JsonWindwardContext(WindwardRequest windwardRequest, WindwardResponse windwardResponse) {
        super(windwardRequest, windwardResponse);
    }

    @Override
    public void doOnRequest() {
        for (String header : this.windwardRequest.getHeader("Content-Type")) {
            MediaType mediaType = MediaType.detectMediaType(header);
            if (!MediaType.APPLICATION_JSON_VALUE.equals((Object)mediaType)) continue;
            return;
        }
        throw new ValidationException("Content type must be JSON!");
    }

    @Override
    public <R> void doOnResponse(R r) {
        this.writeJson(r);
    }
}

