/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.json;

import org.flmelody.core.exception.JsonException;
import org.flmelody.core.plugin.json.GsonPlugin;
import org.flmelody.core.plugin.json.JacksonPlugin;
import org.flmelody.core.plugin.json.JsonPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoJsonBinder {
    protected static final Logger logger = LoggerFactory.getLogger(AutoJsonBinder.class);
    public static JsonPlugin jsonPlugin;

    static {
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            jsonPlugin = new JacksonPlugin();
        }
        catch (ClassNotFoundException e) {
            logger.atInfo().log("Jackson lib not exist, will try gson instead");
        }
        if (jsonPlugin == null) {
            try {
                Class.forName("com.google.gson.Gson");
                jsonPlugin = new GsonPlugin();
            }
            catch (ClassNotFoundException e) {
                logger.atInfo().log("Gson lib not found");
            }
        }
        if (jsonPlugin == null) {
            throw new JsonException("No suitable json library");
        }
    }
}

