/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import org.flmelody.core.exception.JsonDeserializeException;
import org.flmelody.core.exception.JsonSerializeException;
import org.flmelody.core.plugin.json.JsonPlugin;

public class GsonPlugin
implements JsonPlugin {
    protected final Gson gson = new GsonBuilder().serializeNulls().create();

    @Override
    public <I> String toJson(I data) {
        try {
            if (data instanceof String) {
                String result = String.valueOf(data);
                try {
                    this.gson.getAdapter(JsonElement.class).fromJson(result);
                    return result;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.gson.toJson(data);
        }
        catch (Exception e) {
            throw new JsonSerializeException(e);
        }
    }

    @Override
    public <O> O toObject(String json, Class<O> clazz) {
        try {
            return (O)this.gson.fromJson(json, clazz);
        }
        catch (Exception e) {
            throw new JsonDeserializeException(e);
        }
    }

    @Override
    public <I, O> O toObject(I data, Type type) {
        return (O)this.gson.fromJson(this.toJson(data), TypeToken.get((Type)type));
    }
}

