/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.ws;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.flmelody.core.Order;
import org.flmelody.core.plugin.ws.WebSocketPlugin;
import org.flmelody.core.ws.WebSocketParser;
import org.flmelody.core.ws.codec.WebSocketCodec;
import org.flmelody.util.AntPathMatcher;

public class ExtensionalWebSocketPlugin
implements WebSocketPlugin {
    private final AntPathMatcher pathMatcher = AntPathMatcher.newBuild().withIgnoreCase().build();
    protected final String pattern;
    private final List<WebSocketCodec> webSocketCodecs;
    private final List<WebSocketParser<?>> webSocketParsers;

    public ExtensionalWebSocketPlugin() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public ExtensionalWebSocketPlugin(List<WebSocketCodec> webSocketCodecs, List<WebSocketParser<?>> webSocketParsers) {
        this("/**", webSocketCodecs, webSocketParsers);
    }

    public ExtensionalWebSocketPlugin(String pattern, List<WebSocketCodec> webSocketCodecs, List<WebSocketParser<?>> webSocketParsers) {
        if (pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("Pattern can't be empty");
        }
        this.pattern = pattern;
        this.webSocketCodecs = webSocketCodecs == null ? Collections.emptyList() : webSocketCodecs.stream().sorted(Comparator.comparingInt(Order::getOrder)).collect(Collectors.toList());
        this.webSocketParsers = webSocketParsers == null ? Collections.emptyList() : webSocketParsers.stream().sorted(Comparator.comparingInt(Order::getOrder)).collect(Collectors.toList());
    }

    public boolean isMatch(String path) {
        return this.pathMatcher.isMatch(this.pattern, path);
    }

    public List<WebSocketCodec> getWebSocketCodecs() {
        return this.webSocketCodecs;
    }

    public List<WebSocketParser<?>> getWebSocketParsers() {
        return this.webSocketParsers;
    }
}

