/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FunctionDefinition {
    private static final FunctionDefinition EMPTY_DEFINITION = new FunctionDefinition();
    private String classname;
    private String method;
    private final List<Class<?>> parameterTypes = new ArrayList();
    private Class<?> returnType;

    private FunctionDefinition() {
    }

    public static FunctionDefinition empty() {
        return EMPTY_DEFINITION;
    }

    public static FunctionDefinitionBuilder builder() {
        return new FunctionDefinitionBuilder(new FunctionDefinition());
    }

    public String getClassname() {
        return this.classname;
    }

    public String getMethod() {
        return this.method;
    }

    public List<Class<?>> getParameterTypes() {
        return Collections.unmodifiableList(this.parameterTypes);
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public static class FunctionDefinitionBuilder {
        private final FunctionDefinition functionDefinition;

        private FunctionDefinitionBuilder(FunctionDefinition functionDefinition) {
            this.functionDefinition = functionDefinition;
        }

        public FunctionDefinitionBuilder classname(String classname) {
            this.functionDefinition.classname = classname;
            return this;
        }

        public FunctionDefinitionBuilder method(String method) {
            this.functionDefinition.method = method;
            return this;
        }

        public FunctionDefinitionBuilder parameterType(Class<?> parameterType) {
            this.functionDefinition.parameterTypes.add(parameterType);
            return this;
        }

        public FunctionDefinitionBuilder returnType(Class<?> returnType) {
            this.functionDefinition.returnType = returnType;
            return this;
        }

        public FunctionDefinition build() {
            return this.functionDefinition;
        }
    }
}

