/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.support;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import org.flmelody.core.exception.WindwardException;
import org.flmelody.support.FunctionDefinition;

public final class FunctionHelper {
    private FunctionHelper() {
        throw new UnsupportedOperationException();
    }

    public static <F> FunctionDefinition resolveFunction(F function) {
        return FunctionHelper.findFunctionSmartly(function);
    }

    private static <F> FunctionDefinition findFunctionSmartly(F function) {
        String functionClassName = function.getClass().getName();
        int lambdaMarkerIndex = functionClassName.indexOf("$$Lambda$");
        if (lambdaMarkerIndex == -1) {
            return FunctionHelper.findRegularFunction(function);
        }
        if (function instanceof Serializable) {
            return FunctionHelper.findLambdaFunction(function);
        }
        return FunctionDefinition.empty();
    }

    private static <F> FunctionDefinition findRegularFunction(F function) {
        FunctionDefinition.FunctionDefinitionBuilder builder = FunctionDefinition.builder();
        Method method = function.getClass().getMethods()[0];
        Class<?>[] parameterTypes = method.getParameterTypes();
        builder.classname(function.getClass().getName()).method(method.getName()).parameterType(parameterTypes.length == 0 ? null : parameterTypes[0]).returnType(method.getReturnType());
        return builder.build();
    }

    private static <F> FunctionDefinition findLambdaFunction(F function) {
        FunctionDefinition.FunctionDefinitionBuilder builder = FunctionDefinition.builder();
        try {
            SerializedLambda serializedLambda = FunctionHelper.getSerializedLambda(function);
            String instantiatedMethodType = serializedLambda.getInstantiatedMethodType();
            String parameterTypeString = instantiatedMethodType.substring(2, instantiatedMethodType.indexOf(";")).replace("/", ".");
            String resultTypeString = instantiatedMethodType.substring(instantiatedMethodType.indexOf(")") + 2, instantiatedMethodType.length() - 1).replace("/", ".");
            Class<?> parameterType = Class.forName(parameterTypeString, true, function.getClass().getClassLoader());
            Class<?> resultType = Class.forName(resultTypeString, true, function.getClass().getClassLoader());
            builder.classname(serializedLambda.getImplClass().replace("/", ".")).method(serializedLambda.getImplMethodName()).parameterType(parameterType).returnType(resultType);
        }
        catch (Exception e) {
            throw new WindwardException(e);
        }
        return builder.build();
    }

    private static <F> SerializedLambda getSerializedLambda(F lambda) {
        return FunctionHelper.writeReplace(lambda);
    }

    private static <F> SerializedLambda writeReplace(F lambda) {
        try {
            Method method = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            return (SerializedLambda)method.invoke(lambda, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to obtain writeReplace method", e);
        }
    }
}

