/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flmelody.core.FunctionMetaInfo;
import org.flmelody.core.HttpMethod;
import org.flmelody.core.RouterGroup;
import org.flmelody.core.Windward;
import org.flmelody.core.context.EnhancedWindwardContext;
import org.flmelody.core.context.ResourceWindwardContext;
import org.flmelody.core.context.SimpleWindwardContext;
import org.flmelody.core.context.WindwardContext;
import org.flmelody.core.exception.RouterMappingException;
import org.flmelody.core.exception.WindwardException;
import org.flmelody.core.plugin.resource.ResourcePluginProxy;
import org.flmelody.core.sse.SseEjector;
import org.flmelody.core.sse.SseWindwardContext;
import org.flmelody.core.wind.event.RouterBindEvent;
import org.flmelody.core.ws.WebSocketWindwardContext;
import org.flmelody.core.ws.authentication.AuthorizationProvider;
import org.flmelody.support.EnhancedFunction;
import org.flmelody.support.FunctionDefinition;
import org.flmelody.util.AntPathMatcher;
import org.flmelody.util.UrlUtil;

public abstract class AbstractRouterGroup<M>
implements RouterGroup<M> {
    private final M manager;
    private String groupPath;
    private final Map<String, Map<String, ? super Object>> routers = Collections.synchronizedMap(new LinkedHashMap(16));
    private final AntPathMatcher antPathMatcher = AntPathMatcher.newBuild().build();
    private final Map<String, Boolean> matchedRouter = new ConcurrentHashMap<String, Boolean>();
    protected boolean resourceRouter;

    protected AbstractRouterGroup(M manager) {
        this(manager, "/");
    }

    protected AbstractRouterGroup(M manager, String groupPath) {
        this.manager = manager;
        this.setGroupPath(groupPath);
    }

    protected void setGroupPath(String groupPath) {
        if (!groupPath.startsWith("/")) {
            groupPath = "/" + groupPath;
        }
        this.groupPath = groupPath;
    }

    @Override
    public M end() {
        return this.manager;
    }

    @Override
    public <R> RouterGroup<M> get(String relativePath, Supplier<R> supplier) {
        return this.http(HttpMethod.GET, relativePath, (Supplier)supplier);
    }

    @Override
    public RouterGroup<M> get(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        return this.http(HttpMethod.GET, relativePath, (Consumer)consumer);
    }

    @Override
    public <C extends EnhancedWindwardContext> RouterGroup<M> get(String relativePath, EnhancedFunction<C, ?> function) {
        return this.http(HttpMethod.GET, relativePath, (EnhancedFunction)function);
    }

    @Override
    public <R> RouterGroup<M> put(String relativePath, Supplier<R> supplier) {
        return this.http(HttpMethod.PUT, relativePath, (Supplier)supplier);
    }

    @Override
    public RouterGroup<M> put(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        return this.http(HttpMethod.PUT, relativePath, (Consumer)consumer);
    }

    @Override
    public <C extends EnhancedWindwardContext> RouterGroup<M> put(String relativePath, EnhancedFunction<C, ?> function) {
        return this.http(HttpMethod.PUT, relativePath, (EnhancedFunction)function);
    }

    @Override
    public <R> RouterGroup<M> post(String relativePath, Supplier<R> supplier) {
        return this.http(HttpMethod.POST, relativePath, (Supplier)supplier);
    }

    @Override
    public RouterGroup<M> post(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        return this.http(HttpMethod.POST, relativePath, (Consumer)consumer);
    }

    @Override
    public <C extends EnhancedWindwardContext> RouterGroup<M> post(String relativePath, EnhancedFunction<C, ?> function) {
        return this.http(HttpMethod.POST, relativePath, (EnhancedFunction)function);
    }

    @Override
    public <R> RouterGroup<M> delete(String relativePath, Supplier<R> supplier) {
        return this.http(HttpMethod.DELETE, relativePath, (Supplier)supplier);
    }

    @Override
    public RouterGroup<M> delete(String relativePath, Consumer<SimpleWindwardContext> consumer) {
        return this.http(HttpMethod.DELETE, relativePath, (Consumer)consumer);
    }

    @Override
    public <C extends EnhancedWindwardContext> RouterGroup<M> delete(String relativePath, EnhancedFunction<C, ?> function) {
        return this.http(HttpMethod.DELETE, relativePath, (EnhancedFunction)function);
    }

    @Override
    public RouterGroup<M> sse(String relativePath, EnhancedFunction<SseWindwardContext, SseEjector> function) {
        return this.sse(HttpMethod.GET, relativePath, (EnhancedFunction)function);
    }

    @Override
    public RouterGroup<M> sse(HttpMethod httpMethod, String relativePath, EnhancedFunction<SseWindwardContext, SseEjector> function) {
        return this.http(httpMethod, relativePath, function);
    }

    @Override
    public RouterGroup<M> ws(String relativePath, Consumer<WebSocketWindwardContext> consumer, AuthorizationProvider ... authorizationProviders) {
        this.registerRouter(relativePath, HttpMethod.GET.name(), consumer, WebSocketWindwardContext.class, authorizationProviders);
        return this;
    }

    @Override
    public RouterGroup<M> resources(String staticResourceLocation, String ... pathPatterns) {
        if (staticResourceLocation == null || staticResourceLocation.trim().isEmpty()) {
            throw new WindwardException("Illegal staticResourceLocation!");
        }
        if (pathPatterns != null) {
            for (String pathPattern : pathPatterns) {
                this.registerRouter(pathPattern, HttpMethod.GET.name(), ResourcePluginProxy.current().mappingResource(staticResourceLocation, pathPatterns), ResourceWindwardContext.class, new Object[0]);
            }
            if (!this.resourceRouter) {
                this.resourceRouter = true;
            }
        }
        return this;
    }

    @Override
    public <R> RouterGroup<M> http(HttpMethod httpMethod, String relativePath, Supplier<R> supplier) {
        this.registerRouter(relativePath, httpMethod.name(), supplier, SimpleWindwardContext.class, new Object[0]);
        return this;
    }

    @Override
    public RouterGroup<M> http(HttpMethod httpMethod, String relativePath, Consumer<SimpleWindwardContext> consumer) {
        this.registerRouter(relativePath, httpMethod.name(), consumer, SimpleWindwardContext.class, new Object[0]);
        return this;
    }

    @Override
    public <C extends EnhancedWindwardContext> RouterGroup<M> http(HttpMethod httpMethod, String relativePath, EnhancedFunction<C, ?> function) {
        this.registerRouter(relativePath, httpMethod.name(), function, EnhancedWindwardContext.class, new Object[0]);
        return this;
    }

    @Override
    public <R> R matchRouter(String relativePath, String method) {
        if (!relativePath.startsWith(this.groupPath)) {
            return null;
        }
        if (relativePath.endsWith("/") && !"/".equals(relativePath)) {
            relativePath = relativePath.replaceFirst("/$", "");
        }
        if (!this.routers.containsKey(relativePath = relativePath.replaceAll("[{}]", ""))) {
            Set<String> routerKeys = this.routers.keySet();
            for (String routerKey : routerKeys) {
                int routerCount;
                Pattern compiledPattern = Pattern.compile("\\{(.*?)}");
                Matcher compiledMatcher = compiledPattern.matcher(routerKey);
                if (!compiledMatcher.find()) {
                    if (!HttpMethod.GET.name().equalsIgnoreCase(method) || !this.resourceRouter) continue;
                    Boolean result = this.matchedRouter.get(relativePath);
                    if (Boolean.TRUE.equals(result)) {
                        return (R)this.routers.get(routerKey).get(method);
                    }
                    boolean matched = this.antPathMatcher.isMatch(routerKey, relativePath);
                    this.matchedRouter.put(relativePath, matched);
                    if (!matched) continue;
                    return (R)this.routers.get(routerKey).get(method);
                }
                String routerRegex = routerKey.replaceAll("\\{(.*?)}", "(.+)");
                if (!relativePath.matches(routerRegex)) continue;
                int pathCount = new StringTokenizer(relativePath, "/").countTokens();
                if (pathCount != (routerCount = new StringTokenizer(routerRegex, "/").countTokens())) {
                    return null;
                }
                FunctionMetaInfo functionMetaInfo = (FunctionMetaInfo)this.routers.get(routerKey).get(method);
                if (functionMetaInfo == null) {
                    return null;
                }
                Map<String, Object> pathVariables = functionMetaInfo.getPathVariables();
                ArrayList<String> keys = new ArrayList<String>(pathVariables.keySet());
                Pattern pattern = Pattern.compile(routerRegex);
                Matcher matcher = pattern.matcher(relativePath);
                int groupCount = matcher.groupCount();
                while (matcher.find()) {
                    for (int j = 0; j < Math.min(groupCount, keys.size()); ++j) {
                        pathVariables.put((String)keys.get(j), matcher.group(j + 1));
                    }
                }
                return (R)functionMetaInfo;
            }
            return null;
        }
        return (R)this.routers.get(relativePath).get(method);
    }

    private <I> void registerRouter(String relativePath, String method, I i, Class<? extends WindwardContext> clazz, Object ... args) {
        String path = UrlUtil.buildUrl(this.groupPath, relativePath);
        Map<String, Object> pathVariables = this.checkPlaceholder(path);
        FunctionMetaInfo<I> functionMetaInfo = new FunctionMetaInfo<I>(path, i, clazz, pathVariables, args);
        if (this.routers.containsKey(path)) {
            this.routers.get(path).put(method, functionMetaInfo);
        } else {
            HashMap<String, FunctionMetaInfo<I>> routerMap = new HashMap<String, FunctionMetaInfo<I>>(16);
            routerMap.put(method, functionMetaInfo);
            this.routers.put(path, routerMap);
        }
        if (this.manager instanceof Windward) {
            FunctionDefinition functionDefinition = functionMetaInfo.getFunctionDefinition();
            if (functionDefinition.equals(FunctionDefinition.empty())) {
                return;
            }
            ((Windward)this.manager).publishEvent(RouterBindEvent.builder().requestUrl(path).classname(functionDefinition.getClassname()).method(functionDefinition.getMethod()).build());
        }
    }

    private Map<String, Object> checkPlaceholder(String path) {
        LinkedHashMap<String, Object> pathVariables = new LinkedHashMap<String, Object>(16);
        Pattern pattern = Pattern.compile("(\\{(.*?)})");
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            String variable = matcher.group(2);
            if (variable.trim().isEmpty()) {
                throw new RouterMappingException("Path variable name is empty!");
            }
            pathVariables.put(variable, null);
        }
        return pathVariables;
    }
}

