/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.flmelody.core.MediaType;
import org.flmelody.core.ResponseWriter;
import org.flmelody.core.Windward;
import org.flmelody.core.netty.event.DestroyDelayEvent;
import org.flmelody.core.plugin.json.JsonPlugin;
import org.flmelody.core.sse.SseChunkTail;

public class NettyResponseWriter
implements ResponseWriter {
    private final ChannelHandlerContext ctx;
    private final boolean keepConnection;

    public NettyResponseWriter(ChannelHandlerContext ctx, boolean keepConnection) {
        this.ctx = ctx;
        this.keepConnection = keepConnection;
    }

    @Override
    public <T> void write(int code, T data) {
        this.write(code, MediaType.APPLICATION_JSON_VALUE.value, data);
    }

    @Override
    public <T> void write(int code, String contentType, T data) {
        this.write(code, contentType, data, !this.keepConnection);
    }

    @Override
    public <T> void write(int code, String contentType, Map<String, Object> headers, T data) {
        this.write(code, contentType, headers, data, !this.keepConnection);
    }

    @Override
    public <T> void write(int code, String contentType, T data, boolean close) {
        this.write(code, contentType, Collections.emptyMap(), data, close);
    }

    @Override
    public <T> void write(int code, String contentType, Map<String, Object> headers, T data, boolean close) {
        this.write(code, contentType, headers, data, close, true);
    }

    @Override
    public <T> void write(int code, String contentType, Map<String, Object> headers, T data, boolean close, boolean flush) {
        Channel channel = this.ctx.channel();
        if (!channel.isActive()) {
            return;
        }
        MediaType mediaType = MediaType.detectMediaType(contentType);
        if (this.chunkedResponse(headers)) {
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            this.paddingHeaders((HttpResponse)httpResponse, mediaType, headers, close);
            this.ctx.write((Object)httpResponse);
            if (data instanceof SseChunkTail) {
                this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                this.ctx.fireUserEventTriggered((Object)DestroyDelayEvent.DESTROY_DELAY);
            } else {
                ByteBuf response = this.resolveRawResponse(mediaType, data);
                ByteBufInputStream contentStream = new ByteBufInputStream(response);
                this.ctx.writeAndFlush((Object)new ChunkedStream((InputStream)contentStream));
            }
        } else {
            ByteBuf response = this.resolveRawResponse(mediaType, data);
            DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, response);
            httpResponse.setStatus(HttpResponseStatus.valueOf((int)code));
            this.paddingHeaders((HttpResponse)httpResponse, mediaType, headers, close);
            if (!close && flush) {
                this.ctx.writeAndFlush((Object)httpResponse);
            } else {
                this.ctx.write((Object)httpResponse);
            }
        }
        if (close) {
            this.close();
        }
    }

    @Override
    public <T> void writeAndClose(int code, String contentType, T data) {
        this.write(code, contentType, data, Boolean.TRUE);
    }

    @Override
    public void flush() {
        this.ctx.flush();
    }

    @Override
    public void close() {
        if (this.ctx.channel().isActive()) {
            this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private <T> ByteBuf resolveRawResponse(MediaType mediaType, T rawResponse) {
        ByteBuf response = rawResponse == null ? Unpooled.EMPTY_BUFFER : (MediaType.APPLICATION_JSON_VALUE.equals((Object)mediaType) ? Unpooled.copiedBuffer((CharSequence)Windward.plugin(JsonPlugin.class).toJson(rawResponse), (Charset)CharsetUtil.UTF_8) : Unpooled.copiedBuffer((CharSequence)String.valueOf(rawResponse), (Charset)CharsetUtil.UTF_8));
        return response;
    }

    private void paddingHeaders(HttpResponse httpResponse, MediaType mediaType, Map<String, Object> headers, boolean close) {
        HttpHeaders httpHeaders = httpResponse.headers();
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType.value);
        if (headers != null && !headers.isEmpty()) {
            headers.keySet().forEach(key -> httpHeaders.set(key, headers.get(key)));
        }
        if (httpResponse instanceof ByteBufHolder) {
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, ((ByteBufHolder)httpResponse).content().readableBytes());
        }
        if (!close) {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
    }

    private boolean chunkedResponse(Map<String, Object> headers) {
        return headers != null && !headers.isEmpty() && "chunked".equals(headers.get("Transfer-Encoding"));
    }
}

