/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.flmelody.core.HttpStatus;
import org.flmelody.core.MediaType;
import org.flmelody.core.WindwardRequest;
import org.flmelody.core.context.ResourceWindwardContext;
import org.flmelody.core.context.WindwardContext;
import org.flmelody.core.exception.ResourceNotFoundException;
import org.flmelody.core.exception.WindwardException;
import org.flmelody.core.plugin.resource.ResourcePlugin;
import org.flmelody.core.plugin.resource.StaticResource;
import org.flmelody.util.UrlUtil;

public class BaseStaticResourcePlugin
implements ResourcePlugin,
Consumer<WindwardContext> {
    protected final Map<String, String> mappedResources = new LinkedHashMap<String, String>();
    protected final String pattern = ".*\\.[a-z|A-Z]+$";

    @Override
    public void accept(WindwardContext windwardContext) {
        String mimeType;
        if (!(windwardContext instanceof ResourceWindwardContext)) {
            windwardContext.write(HttpStatus.INTERNAL_SERVER_ERROR.value(), MediaType.APPLICATION_JSON_VALUE.value, null);
            return;
        }
        ResourceWindwardContext resourceWindwardContext = (ResourceWindwardContext)windwardContext;
        WindwardRequest windwardRequest = resourceWindwardContext.windwardRequest();
        String fileUri = windwardRequest.getUri();
        StaticResource staticResource = StaticResource.newBuilder().fileUri(fileUri).build();
        String resource = this.findResource(this.mappedResources.get(resourceWindwardContext.getMatchedPath()), staticResource);
        Path path = new File(staticResource.getFileUri()).toPath();
        try {
            mimeType = Files.probeContentType(path);
        }
        catch (IOException e) {
            throw new WindwardException(e);
        }
        resourceWindwardContext.write(HttpStatus.OK.value(), MediaType.detectMediaType((String)mimeType).value, resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String findResource(String staticResourceLocation, StaticResource staticResource) {
        String fileUri = staticResource.getFileUri();
        if (!fileUri.startsWith(staticResourceLocation)) {
            StaticResource.newBuilder(staticResource).fileUri(UrlUtil.buildUrl(staticResourceLocation, fileUri));
        }
        try (InputStream in = this.getClass().getResourceAsStream(staticResource.getFileUri());){
            if (in == null) throw new ResourceNotFoundException("No matched resource!");
            if (in instanceof ByteArrayInputStream) {
                throw new ResourceNotFoundException("No matched resource!");
            }
            boolean validResource = staticResource.getFileUri().matches(".*\\.[a-z|A-Z]+$");
            if (!validResource && in.available() <= 0) {
                throw new ResourceNotFoundException("No matched resource!");
            }
            String string = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new WindwardException(e);
        }
    }

    @Override
    public final ResourcePlugin mappingResource(String staticResourceLocation, String ... pathPatterns) {
        if (pathPatterns != null) {
            for (String pathPattern : pathPatterns) {
                this.mappedResources.put(pathPattern, staticResourceLocation);
            }
        }
        return this;
    }
}

