/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.resource;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.flmelody.core.exception.HandlerNotFoundException;
import org.flmelody.core.exception.ResourceNotFoundException;
import org.flmelody.core.plugin.resource.BaseStaticResourcePlugin;
import org.flmelody.core.plugin.resource.StaticResource;
import org.flmelody.util.UrlUtil;

public class FixedStaticResourcePlugin
extends BaseStaticResourcePlugin {
    private final Set<String> fixedPages = new HashSet<String>(Collections.singletonList("index.html"));
    private final boolean ignoredPattern;

    public FixedStaticResourcePlugin() {
        this(true);
    }

    public FixedStaticResourcePlugin(boolean ignoredPattern) {
        this.ignoredPattern = ignoredPattern;
    }

    public void appendPages(String ... pageNames) {
        if (pageNames != null) {
            this.fixedPages.addAll(Arrays.asList(pageNames));
        }
    }

    @Override
    protected String findResource(String staticResourceLocation, StaticResource staticResource) {
        try {
            return super.findResource(staticResourceLocation, staticResource);
        }
        catch (HandlerNotFoundException e) {
            String originalUri = staticResource.getFileUri();
            for (String fixedPage : this.fixedPages) {
                boolean ignoredResource;
                String fileUri = originalUri;
                if (this.ignoredPattern && (ignoredResource = fileUri.matches(".*\\.[a-z|A-Z]+$"))) {
                    throw e;
                }
                int index = fileUri.lastIndexOf("/");
                if (index < 0) {
                    try {
                        return super.findResource(staticResourceLocation, StaticResource.newBuilder(staticResource).fileUri(fixedPage).build());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    fileUri = UrlUtil.buildUrl(fileUri, fixedPage);
                    return super.findResource(staticResourceLocation, StaticResource.newBuilder(staticResource).fileUri(fileUri).build());
                }
                catch (Exception ignored) {
                    StringTokenizer stringTokenizer = new StringTokenizer(originalUri, "/");
                    String possibleUri = "/";
                    while (stringTokenizer.hasMoreTokens()) {
                        if ((possibleUri = UrlUtil.buildUrl(possibleUri, stringTokenizer.nextToken())).chars().filter(i -> i == 47).count() <= 1L || possibleUri.equals(originalUri)) continue;
                        try {
                            return super.findResource(staticResourceLocation, StaticResource.newBuilder(staticResource).fileUri(UrlUtil.buildUrl(possibleUri, fixedPage)).build());
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
            throw new ResourceNotFoundException("No matched resource!");
        }
    }
}

