/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.plugin.view;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewEngineDetector {
    public static boolean AVAILABLE_GROOVY_ENGINE;
    public static boolean AVAILABLE_THYMELEAF_ENGINE;
    public static boolean AVAILABLE_FREEMARKER_ENGINE;
    private static final Logger logger;

    static {
        logger = LoggerFactory.getLogger(ViewEngineDetector.class);
        try {
            Class.forName("groovy.text.markup.MarkupTemplateEngine");
            AVAILABLE_GROOVY_ENGINE = true;
        }
        catch (ClassNotFoundException e) {
            AVAILABLE_GROOVY_ENGINE = false;
            logger.atDebug().log("Missing Groovy template engine dependency, Groovy templates not available");
        }
        try {
            Class.forName("org.thymeleaf.TemplateEngine");
            AVAILABLE_THYMELEAF_ENGINE = true;
        }
        catch (ClassNotFoundException e) {
            AVAILABLE_THYMELEAF_ENGINE = false;
            logger.atDebug().log("Missing Thymeleaf template engine dependency, Thymeleaf templates not available");
        }
        try {
            Class.forName("freemarker.template.Configuration");
            AVAILABLE_FREEMARKER_ENGINE = true;
        }
        catch (ClassNotFoundException e) {
            AVAILABLE_FREEMARKER_ENGINE = false;
            logger.atDebug().log("Missing Freemarker template engine dependency, Freemarker templates not available");
        }
    }
}

