/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.sse;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.flmelody.core.sse.SseEventSource;
import org.flmelody.core.sse.SseWindwardContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SseEjector {
    private static final Logger logger = LoggerFactory.getLogger(SseEjector.class);
    private final SseWindwardContext sseWindwardContext;
    protected final AtomicBoolean complete = new AtomicBoolean(false);
    protected final AtomicLong timeout = new AtomicLong(0L);
    protected final EjectorCallback callback = new EjectorCallback();

    public SseEjector(SseWindwardContext sseWindwardContext) {
        this.sseWindwardContext = sseWindwardContext;
    }

    public void send(SseEventSource.SseEventSourceBuilder builder) {
        this.sseWindwardContext.send(builder.build());
    }

    public SseEjector keepAlive(Long seconds) {
        if (this.complete.get()) {
            return this;
        }
        if (seconds < 0L) {
            throw new IllegalArgumentException("SseEjector survival time must be greater than or equal to 0 seconds! ");
        }
        this.timeout.compareAndSet(0L, seconds);
        return this;
    }

    protected long getTimeout() {
        return this.timeout.get();
    }

    protected EjectorCallback getCallback() {
        return this.callback;
    }

    public void complete() {
        if (this.complete.compareAndSet(false, true)) {
            this.sseWindwardContext.complete();
        } else {
            logger.atWarn().log("SseEjector already completed! ");
        }
    }

    private class EjectorCallback
    implements Runnable {
        private EjectorCallback() {
        }

        @Override
        public void run() {
            SseEjector.this.complete();
        }
    }
}

