/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.wind;

import java.util.ArrayList;
import java.util.List;
import org.flmelody.core.Windward;
import org.flmelody.core.wind.WindManager;
import org.flmelody.core.wind.event.Event;
import org.flmelody.core.wind.listener.Listener;

public abstract class AbstractWindManager
implements WindManager {
    private final Windward windward;
    protected final List<Listener> listeners = new ArrayList<Listener>();
    protected final List<Event> events = new ArrayList<Event>();

    protected AbstractWindManager(Windward windward) {
        this.windward = windward;
    }

    @Override
    public void join(Listener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void loadEvent(Event event) {
        this.events.add(event);
    }

    @Override
    public void triggerEvent() {
        for (Event event : this.events) {
            for (Listener listener : this.listeners) {
                listener.cope(this.windward, event);
            }
        }
    }
}

