/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.wind.event;

import org.flmelody.core.wind.event.Event;

public class RouterBindEvent
implements Event {
    private String requestUrl;
    private String classname;
    private String method;

    private RouterBindEvent() {
    }

    public static RouterBindEventBuilder builder() {
        return new RouterBindEventBuilder(new RouterBindEvent());
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getMethod() {
        return this.method;
    }

    public static class RouterBindEventBuilder {
        private final RouterBindEvent routerBindEvent;

        private RouterBindEventBuilder(RouterBindEvent routerBindEvent) {
            this.routerBindEvent = routerBindEvent;
        }

        public RouterBindEventBuilder requestUrl(String requestUrl) {
            this.routerBindEvent.requestUrl = requestUrl;
            return this;
        }

        public RouterBindEventBuilder classname(String classname) {
            this.routerBindEvent.classname = classname;
            return this;
        }

        public RouterBindEventBuilder method(String method) {
            this.routerBindEvent.method = method;
            return this;
        }

        public RouterBindEvent build() {
            if (this.routerBindEvent.classname == null || this.routerBindEvent.method == null) {
                throw new IllegalArgumentException("RouterBindEvent should contain both classname and method's name !");
            }
            return this.routerBindEvent;
        }
    }
}

