/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.core.ws;

import java.util.Collections;
import java.util.List;
import org.flmelody.core.HttpStatus;
import org.flmelody.core.MediaType;
import org.flmelody.core.WindwardRequest;
import org.flmelody.core.WindwardResponse;
import org.flmelody.core.context.AbstractWindwardContext;
import org.flmelody.core.ws.WebSocketEvent;
import org.flmelody.core.ws.authentication.AuthorizationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSocketWindwardContext
extends AbstractWindwardContext {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketWindwardContext.class);
    private final List<AuthorizationProvider> authorizationProviders;
    private WebSocketEvent webSocketEvent;
    private Object webSocketData;
    private boolean httpResponse;
    private boolean upgradedContext;

    public WebSocketWindwardContext(WindwardRequest windwardRequest, WindwardResponse windwardResponse) {
        this(windwardRequest, windwardResponse, Collections.emptyList());
    }

    public WebSocketWindwardContext(WindwardRequest windwardRequest, WindwardResponse windwardResponse, List<AuthorizationProvider> providers) {
        super(windwardRequest, windwardResponse);
        this.authorizationProviders = providers;
    }

    public void setWebSocketEvent(WebSocketEvent webSocketEvent) {
        this.webSocketEvent = webSocketEvent;
        this.upgradeContext();
    }

    public void setWebSocketData(Object webSocketData) {
        this.webSocketData = webSocketData;
    }

    public void setHttpResponse(boolean httpResponse) {
        this.httpResponse = httpResponse;
    }

    public WebSocketEvent getWebSocketEvent() {
        return this.webSocketEvent;
    }

    public Object getWebSocketData() {
        return this.webSocketData;
    }

    public boolean isUpgradedContext() {
        return this.upgradedContext;
    }

    private void upgradeContext() {
        if (WebSocketEvent.ON_CONNECT.equals((Object)this.webSocketEvent)) {
            this.upgradedContext = true;
        }
        this.httpResponse = false;
    }

    public boolean authorized() {
        if (this.authorizationProviders == null || this.authorizationProviders.isEmpty()) {
            return true;
        }
        for (AuthorizationProvider authorizationProvider : this.authorizationProviders) {
            if (!authorizationProvider.authenticate(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> void write(int code, String contentType, T data) {
        if (this.processCheck()) {
            super.write(code, contentType, data);
        }
    }

    public <T> void writeBinaryData(T data) {
        if (this.processCheck()) {
            this.windwardResponse.write(HttpStatus.OK.value(), MediaType.WEB_SOCKET_BINARY.value, data);
        }
    }

    private boolean processCheck() {
        if (this.upgradedContext || this.httpResponse) {
            return true;
        }
        logger.atWarn().log("Context not upgraded!");
        return false;
    }

    @Override
    public Boolean isCacheable() {
        return Boolean.TRUE;
    }
}

