/*
 * Decompiled with CFR 0.152.
 */
package org.flmelody.util;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.flmelody.core.exception.ValidationException;
import org.flmelody.core.plugin.json.JsonPlugin;

public final class ValidationUtil {
    private static final ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();

    private ValidationUtil() {
    }

    public static <T> T validate(JsonPlugin jsonPlugin, String content, Class<T> targetClass, Class<?> ... groups) throws ValidationException {
        return ValidationUtil.validate(jsonPlugin.toObject(content, targetClass), groups);
    }

    public static <T> T validate(JsonPlugin jsonPlugin, String content, Type type, Class<?> ... groups) throws ValidationException {
        return (T)ValidationUtil.validate(jsonPlugin.toObject(content, type), groups);
    }

    private static <T> T validate(T target, Class<?> ... groups) {
        Validator validator = validatorFactory.getValidator();
        Set validate = Objects.isNull(groups) ? validator.validate(target, new Class[0]) : validator.validate(target, (Class[])groups);
        Optional first = validate.stream().findFirst();
        if (first.isPresent()) {
            ConstraintViolation constraintViolation = (ConstraintViolation)first.get();
            throw new ValidationException(constraintViolation.getPropertyPath() + " " + constraintViolation.getMessage());
        }
        return target;
    }
}

