/*
 * Decompiled with CFR 0.152.
 */
package korolev.akka;

import akka.actor.ActorSystem;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCode$;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.http.scaladsl.model.ws.BinaryMessage;
import akka.http.scaladsl.model.ws.Message;
import akka.http.scaladsl.model.ws.TextMessage;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import java.io.Serializable;
import korolev.Router;
import korolev.akka.AkkaHttpServerConfig;
import korolev.akka.instances$;
import korolev.akka.util.LoggingReporter;
import korolev.data.Bytes;
import korolev.data.Bytes$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Reporter;
import korolev.effect.Stream;
import korolev.effect.Stream$;
import korolev.server.KorolevService;
import korolev.server.KorolevServiceConfig;
import korolev.state.IdGenerator;
import korolev.state.StateDeserializer;
import korolev.state.StateSerializer;
import korolev.state.StateStorage;
import korolev.web.PathAndQuery;
import korolev.web.PathAndQuery$;
import korolev.web.Request;
import korolev.web.Response;
import levsha.Document;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public <F, S, M> Function1<AkkaHttpServerConfig, Function1<RequestContext, Future<RouteResult>>> akkaHttpService(KorolevServiceConfig<F, S, M> config, Effect<F> evidence$1, StateSerializer<S> evidence$2, StateDeserializer<S> evidence$3, ActorSystem actorSystem, Materializer materializer, ExecutionContext ec) {
        return (Function1 & Serializable)akkaHttpConfig -> {
            KorolevServiceConfig korolevServiceConfig;
            Reporter reporter = config.reporter();
            Reporter.PrintReporter$ printReporter$ = Reporter.PrintReporter$.MODULE$;
            if (reporter == null ? printReporter$ != null : !reporter.equals(printReporter$)) {
                korolevServiceConfig = config;
            } else {
                LoggingReporter x$1 = new LoggingReporter(actorSystem);
                Function2 x$2 = config.copy$default$1();
                StateStorage x$3 = config.copy$default$2();
                PartialFunction x$4 = config.copy$default$3();
                Router x$5 = config.copy$default$4();
                String x$6 = config.copy$default$5();
                Function1 x$7 = config.copy$default$6();
                Function1 x$8 = config.copy$default$7();
                Function1 x$9 = config.copy$default$8();
                Document.Node x$10 = config.copy$default$9();
                int x$11 = config.copy$default$10();
                List x$12 = config.copy$default$11();
                IdGenerator x$13 = config.copy$default$12();
                FiniteDuration x$14 = config.copy$default$13();
                korolevServiceConfig = config.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Reporter)x$1, evidence$1, ec);
            }
            KorolevServiceConfig actualConfig = korolevServiceConfig;
            KorolevService korolevServer = korolev.server.package$.MODULE$.korolevService(actualConfig, evidence$1, evidence$2, evidence$3);
            Function1<RequestContext, Future<RouteResult>> wsRouter = MODULE$.configureWsRoute((KorolevService)korolevServer, (AkkaHttpServerConfig)akkaHttpConfig, (KorolevServiceConfig)actualConfig, evidence$1, evidence$2, evidence$3, materializer, ec);
            Function1<RequestContext, Future<RouteResult>> httpRoute = MODULE$.configureHttpRoute(korolevServer, materializer, evidence$1, ec);
            return Directives$.MODULE$._enhanceRouteWithConcatenation(wsRouter).$tilde(httpRoute);
        };
    }

    private <F, S, M> Function1<RequestContext, Future<RouteResult>> configureWsRoute(KorolevService<F> korolevServer, AkkaHttpServerConfig akkaHttpConfig, KorolevServiceConfig<F, S, M> korolevServiceConfig, Effect<F> evidence$4, StateSerializer<S> evidence$5, StateDeserializer<S> evidence$6, Materializer materializer, ExecutionContext ec) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractRequest(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)request -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractUnmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)path -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractWebSocketUpgrade(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)upgrade -> {
            Tuple2 tuple2 = instances$.MODULE$.SinkCompanionOps(Sink$.MODULE$).korolevStream(evidence$4).preMaterialize(materializer);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Stream inStream = (Stream)tuple2._1();
            Sink inSink = (Sink)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)inStream, (Object)inSink);
            Tuple2 tuple23 = tuple22;
            Stream inStream2 = (Stream)tuple23._1();
            Sink inSink2 = (Sink)tuple23._2();
            Request<Stream> korolevRequest = MODULE$.mkKorolevRequest((HttpRequest)request, path.toString(), (Object)inStream2);
            return Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)Effect$.MODULE$.apply(evidence$4).toFuture(korolevServer.ws(korolevRequest)).map((Function1 & Serializable)x0$1 -> {
                Response response = x0$1;
                if (response == null) {
                    throw new RuntimeException();
                }
                Stream outStream = (Stream)response.body();
                Source source = (Source)instances$.MODULE$.KorolevStreamsOps(outStream, evidence$4).asAkkaSource(ec).map((Function1 & Serializable)text -> new TextMessage.Strict(text));
                Sink sink = ((Flow)Flow$.MODULE$.apply().mapConcat((Function1 & Serializable)x0$2 -> {
                    List list;
                    Message message = x0$2;
                    if (message instanceof TextMessage.Strict) {
                        TextMessage.Strict strict = (TextMessage.Strict)message;
                        String string = strict.text();
                        list = scala.package$.MODULE$.Nil().$colon$colon((Object)string);
                    } else if (message instanceof TextMessage.Streamed) {
                        TextMessage.Streamed streamed = (TextMessage.Streamed)message;
                        streamed.textStream().runWith((Graph)Sink$.MODULE$.ignore(), materializer);
                        list = scala.package$.MODULE$.Nil();
                    } else if (message instanceof BinaryMessage) {
                        BinaryMessage binaryMessage = (BinaryMessage)message;
                        binaryMessage.dataStream().runWith((Graph)Sink$.MODULE$.ignore(), materializer);
                        list = scala.package$.MODULE$.Nil();
                    } else {
                        throw new MatchError((Object)message);
                    }
                    return list;
                })).to((Graph)inSink2);
                HttpResponse httpResponse = upgrade.handleMessages((Graph)Flow$.MODULE$.fromSinkAndSourceCoupled((Graph)sink, (Graph)source), upgrade.handleMessages$default$2());
                return httpResponse;
            }, ec), Marshaller$.MODULE$.futureMarshaller(Marshaller$.MODULE$.fromResponse())));
        })));
    }

    private <F> Function1<RequestContext, Future<RouteResult>> configureHttpRoute(KorolevService<F> korolevServer, Materializer mat, Effect<F> async, ExecutionContext ec) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractUnmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)path -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractRequest(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)request -> {
            Sink sink = instances$.MODULE$.SinkCompanionOps(Sink$.MODULE$).korolevStream(async);
            HttpMethod httpMethod = request.method();
            HttpMethod httpMethod2 = HttpMethods$.MODULE$.GET();
            Stream body = !(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null) ? Stream$.MODULE$.empty(async) : (Stream)((Source)request.entity().dataBytes().map((Function1 & Serializable)x$2 -> Bytes$.MODULE$.wrap(x$2, instances$.MODULE$.akkaByteStringBytesLike()))).toMat(sink, Keep$.MODULE$.right()).run(mat);
            Request<Stream> korolevRequest = MODULE$.mkKorolevRequest((HttpRequest)request, path.toString(), (Object)body);
            Future<HttpResponse> responseF = MODULE$.handleHttpResponse(korolevServer, korolevRequest, async, ec);
            return Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)responseF, Marshaller$.MODULE$.futureMarshaller(Marshaller$.MODULE$.fromResponse())));
        }));
    }

    private <F, Body> Request<Body> mkKorolevRequest(HttpRequest request, String path, Body body) {
        PathAndQuery x$1 = PathAndQuery$.MODULE$.fromString(path).withParams(request.uri().rawQueryString());
        Request.Method x$2 = Request.Method$.MODULE$.fromString(request.method().value());
        Option x$32 = request.headers().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.is("content-length"))).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$4.value()))));
        String x$42 = (String)request.headers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.is("cookie"))).map((Function1 & Serializable)x$6 -> x$6.value()).getOrElse((Function0 & Serializable)() -> "");
        ContentType contentType = request.entity().contentType();
        Seq contentTypeHeaders = contentType.mediaType().isMultipart() ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content-type"), (Object)contentType.toString())})) : (Seq)scala.package$.MODULE$.Seq().empty();
        Seq x$52 = (Seq)((IterableOps)request.headers().map((Function1 & Serializable)h -> new Tuple2((Object)h.name(), (Object)h.value()))).$plus$plus((IterableOnce)contentTypeHeaders);
        Body x$62 = body;
        return new Request(x$2, x$1, x$52, x$32, x$62, x$42);
    }

    private <F> Future<HttpResponse> handleHttpResponse(KorolevService<F> korolevServer, Request<Stream<F, Bytes>> korolevRequest, Effect<F> evidence$7, ExecutionContext ec) {
        return Effect$.MODULE$.apply(evidence$7).toFuture(korolevServer.http(korolevRequest)).map((Function1 & Serializable)x0$1 -> {
            HttpEntity.Chunked chunked;
            Response response = x0$1;
            if (response == null) throw new MatchError((Object)response);
            Response.Status status = response.status();
            Stream body = (Stream)response.body();
            Seq responseHeaders = response.headers();
            Tuple2<Option<ContentType>, List<HttpHeader>> tuple2 = MODULE$.getContentTypeAndResponseHeaders((Seq<Tuple2<String, String>>)responseHeaders);
            if (tuple2 == null) throw new MatchError(tuple2);
            Option contentTypeOpt = (Option)tuple2._1();
            List otherHeaders = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)contentTypeOpt, (Object)otherHeaders);
            Tuple2 tuple23 = tuple22;
            Option contentTypeOpt2 = (Option)tuple23._1();
            List otherHeaders2 = (List)tuple23._2();
            Source bytesSource = (Source)instances$.MODULE$.KorolevStreamsOps(body, evidence$7).asAkkaSource(ec).map((Function1 & Serializable)x$8 -> (ByteString)x$8.as(instances$.MODULE$.akkaByteStringBytesLike()));
            StatusCode statusCode = StatusCode$.MODULE$.int2StatusCode(status.code());
            Option option = response.contentLength();
            if (option instanceof Some) {
                Some some = (Some)option;
                long bytesLength = BoxesRunTime.unboxToLong((Object)some.value());
                chunked = HttpEntity$.MODULE$.apply((ContentType)contentTypeOpt2.getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.NoContentType()), bytesLength, bytesSource);
                return HttpResponse$.MODULE$.apply(statusCode, (Seq)otherHeaders2, (ResponseEntity)chunked, HttpResponse$.MODULE$.apply$default$4());
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                chunked = HttpEntity$.MODULE$.apply((ContentType)contentTypeOpt2.getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.NoContentType()), bytesSource);
            }
            return HttpResponse$.MODULE$.apply(statusCode, (Seq)otherHeaders2, (ResponseEntity)chunked, HttpResponse$.MODULE$.apply$default$4());
        }, ec);
    }

    private Tuple2<Option<ContentType>, List<HttpHeader>> getContentTypeAndResponseHeaders(Seq<Tuple2<String, String>> responseHeaders) {
        Seq headers = (Seq)responseHeaders.map((Function1 & Serializable)x0$1 -> {
            RawHeader rawHeader;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String value;
                String name = (String)tuple2._1();
                HttpHeader.ParsingResult parsingResult = HttpHeader$.MODULE$.parse(name, value = (String)tuple2._2(), HttpHeader$.MODULE$.parse$default$3());
                if (parsingResult instanceof HttpHeader.ParsingResult$.Ok) {
                    HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)parsingResult;
                    HttpHeader header = ok.header();
                    rawHeader = header;
                } else {
                    rawHeader = new RawHeader(name, value);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            RawHeader rawHeader2 = rawHeader;
            return rawHeader2;
        });
        Tuple2 tuple2 = headers.partition((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$getContentTypeAndResponseHeaders$2(x$9)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq contentTypeHeaders = (Seq)tuple2._1();
        Seq otherHeaders = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)contentTypeHeaders, (Object)otherHeaders);
        Tuple2 tuple23 = tuple22;
        Seq contentTypeHeaders2 = (Seq)tuple23._1();
        Seq otherHeaders2 = (Seq)tuple23._2();
        Option contentTypeOpt = contentTypeHeaders2.headOption().flatMap((Function1 & Serializable)h -> ContentType$.MODULE$.parse(h.value()).right().toOption());
        return new Tuple2((Object)contentTypeOpt, (Object)otherHeaders2.toList());
    }

    public static final /* synthetic */ boolean $anonfun$getContentTypeAndResponseHeaders$2(HttpHeader x$9) {
        String string = x$9.lowercaseName();
        String string2 = "content-type";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private package$() {
    }
}

