/*
 * Decompiled with CFR 0.152.
 */
package korolev.akka.util;

import java.io.Serializable;
import korolev.akka.util.Countdown;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Hub;
import korolev.effect.Hub$;
import korolev.effect.Reporter;
import korolev.effect.Stream;
import korolev.effect.syntax$;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class KorolevStreamPublisher<F, T>
implements Publisher<T> {
    private final Stream<F, T> stream;
    public final Effect<F> korolev$akka$util$KorolevStreamPublisher$$evidence$1;
    public final Reporter korolev$akka$util$KorolevStreamPublisher$$reporter;
    private boolean hasActualSubscriber;
    private final Hub<F, T> hub;

    public KorolevStreamPublisher(Stream<F, T> stream, boolean fanout, Effect<F> evidence$1, ExecutionContext ec) {
        this.stream = stream;
        this.korolev$akka$util$KorolevStreamPublisher$$evidence$1 = evidence$1;
        this.korolev$akka$util$KorolevStreamPublisher$$reporter = Reporter.PrintReporter$.MODULE$;
        this.hasActualSubscriber = false;
        this.hub = fanout ? Hub$.MODULE$.apply(stream, Hub$.MODULE$.apply$default$2(), evidence$1) : null;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        if (this.hub != null) {
            syntax$.MODULE$.EffectOps(this.hub.newStream(), this.korolev$akka$util$KorolevStreamPublisher$$evidence$1).runAsyncSuccess((Function1)(JProcedure1 & Serializable)newStream -> {
                StreamSubscription subscription = new StreamSubscription(this, newStream, subscriber);
                subscriber.onSubscribe((Subscription)subscription);
            }, this.korolev$akka$util$KorolevStreamPublisher$$reporter);
        } else {
            if (this.hasActualSubscriber) {
                throw new MultipleSubscribersProhibitedException();
            }
            subscriber.onSubscribe((Subscription)new StreamSubscription(this, this.stream, subscriber));
        }
        this.hasActualSubscriber = true;
    }

    public static final /* synthetic */ void korolev$akka$util$KorolevStreamPublisher$StreamSubscription$$_$$lessinit$greater$$anonfun$1(Subscriber subscriber$1, Either x$1) {
        Either either = x$1;
        if (either instanceof Left) {
            Throwable error = (Throwable)((Left)either).value();
            subscriber$1.onError(error);
        } else if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
    }

    public static final /* synthetic */ void korolev$akka$util$KorolevStreamPublisher$StreamSubscription$$_$loop$$anonfun$1$$anonfun$1$$anonfun$1(BoxedUnit x$1) {
        BoxedUnit boxedUnit = x$1;
    }

    public static final class MultipleSubscribersProhibitedException
    extends Exception {
        public MultipleSubscribersProhibitedException() {
            super("Multiple subscribers prohibited for this KorolevStreamPublisher");
        }
    }

    private final class StreamSubscription
    implements Subscription {
        private final Stream<F, T> stream;
        private final Subscriber<? super T> subscriber;
        private final Countdown<F> countdown;
        private final KorolevStreamPublisher<F, T> $outer;

        public StreamSubscription(KorolevStreamPublisher $outer, Stream<F, T> stream, Subscriber<? super T> subscriber) {
            this.stream = stream;
            this.subscriber = subscriber;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.countdown = new Countdown($outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1);
            syntax$.MODULE$.EffectOps(this.loop(), $outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1).runAsync((Function1)((JProcedure1 & Serializable)arg_0 -> KorolevStreamPublisher.korolev$akka$util$KorolevStreamPublisher$StreamSubscription$$_$$lessinit$greater$$anonfun$1(subscriber, arg_0)));
        }

        private F loop() {
            return syntax$.MODULE$.EffectOps(this.countdown.decOrLock(), this.$outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return syntax$.MODULE$.EffectOps(this.stream.pull(), this.$outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1).flatMap((Function1 & Serializable)maybeItem -> {
                    Object object;
                    Option option = maybeItem;
                    if (option instanceof Some) {
                        Object item = ((Some)option).value();
                        this.subscriber.onNext(item);
                        object = this.loop();
                    } else if (None$.MODULE$.equals(option)) {
                        this.subscriber.onComplete();
                        object = Effect$.MODULE$.apply(this.$outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1).unit();
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return syntax$.MODULE$.EffectOps(object, this.$outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1).map((Function1)((JProcedure1 & Serializable)KorolevStreamPublisher::korolev$akka$util$KorolevStreamPublisher$StreamSubscription$$_$loop$$anonfun$1$$anonfun$1$$anonfun$1));
                });
            });
        }

        public void request(long n) {
            this.countdown.unsafeAdd(n);
        }

        public void cancel() {
            syntax$.MODULE$.EffectOps(this.stream.cancel(), this.$outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1).runAsyncForget(this.$outer.korolev$akka$util$KorolevStreamPublisher$$reporter);
        }

        public final KorolevStreamPublisher<F, T> korolev$akka$util$KorolevStreamPublisher$StreamSubscription$$$outer() {
            return this.$outer;
        }
    }
}

