/*
 * Decompiled with CFR 0.152.
 */
package korolev.akka.util;

import java.io.Serializable;
import korolev.akka.util.Countdown;
import korolev.akka.util.KorolevStreamPublisher$MultipleSubscribersProhibitedException$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Hub;
import korolev.effect.Hub$;
import korolev.effect.Reporter;
import korolev.effect.Stream;
import korolev.effect.syntax;
import korolev.effect.syntax$;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class KorolevStreamPublisher<F, T>
implements Publisher<T> {
    private final Stream<F, T> stream;
    public final Effect<F> korolev$akka$util$KorolevStreamPublisher$$evidence$1;
    public final Reporter korolev$akka$util$KorolevStreamPublisher$$reporter;
    private boolean hasActualSubscriber;
    private final Hub<F, T> hub;

    public KorolevStreamPublisher(Stream<F, T> stream, boolean fanout, Effect<F> evidence$1, ExecutionContext ec) {
        this.stream = stream;
        this.korolev$akka$util$KorolevStreamPublisher$$evidence$1 = evidence$1;
        this.korolev$akka$util$KorolevStreamPublisher$$reporter = Reporter.PrintReporter$.MODULE$;
        this.hasActualSubscriber = false;
        this.hub = fanout ? Hub$.MODULE$.apply(stream, Hub$.MODULE$.apply$default$2(), evidence$1) : null;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        if (this.hub != null) {
            Object object = syntax$.MODULE$.EffectOps(this.hub.newStream());
            syntax.EffectOps$.MODULE$.runAsyncSuccess$extension(object, (Function1)(JProcedure1 & Serializable)newStream -> {
                StreamSubscription subscription = new StreamSubscription(this, newStream, subscriber);
                subscriber.onSubscribe((Subscription)subscription);
            }, this.korolev$akka$util$KorolevStreamPublisher$$reporter, this.korolev$akka$util$KorolevStreamPublisher$$evidence$1);
        } else {
            if (this.hasActualSubscriber) {
                throw KorolevStreamPublisher$MultipleSubscribersProhibitedException$.MODULE$.apply();
            }
            subscriber.onSubscribe((Subscription)new StreamSubscription(this, this.stream, subscriber));
        }
        this.hasActualSubscriber = true;
    }

    public static final /* synthetic */ void korolev$akka$util$KorolevStreamPublisher$StreamSubscription$$_$$lessinit$greater$$anonfun$1(Subscriber subscriber$1, Either x$1) {
        Either either = x$1;
        if (either instanceof Left) {
            Throwable error = (Throwable)((Left)either).value();
            subscriber$1.onError(error);
            return;
        }
        if (either instanceof Right) {
            return;
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ void korolev$akka$util$KorolevStreamPublisher$StreamSubscription$$_$loop$$anonfun$1$$anonfun$1$$anonfun$1(BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final class MultipleSubscribersProhibitedException
    extends Exception
    implements Product {
        public static MultipleSubscribersProhibitedException apply() {
            return KorolevStreamPublisher$MultipleSubscribersProhibitedException$.MODULE$.apply();
        }

        public static MultipleSubscribersProhibitedException fromProduct(Product product) {
            return KorolevStreamPublisher$MultipleSubscribersProhibitedException$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(MultipleSubscribersProhibitedException multipleSubscribersProhibitedException) {
            return KorolevStreamPublisher$MultipleSubscribersProhibitedException$.MODULE$.unapply(multipleSubscribersProhibitedException);
        }

        public MultipleSubscribersProhibitedException() {
            super("Multiple subscribers prohibited for this KorolevStreamPublisher");
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MultipleSubscribersProhibitedException)) return false;
            MultipleSubscribersProhibitedException multipleSubscribersProhibitedException = (MultipleSubscribersProhibitedException)object;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MultipleSubscribersProhibitedException;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "MultipleSubscribersProhibitedException";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public MultipleSubscribersProhibitedException copy() {
            return new MultipleSubscribersProhibitedException();
        }
    }

    public final class StreamSubscription
    implements Subscription {
        private final Stream<F, T> stream;
        private final Subscriber<? super T> subscriber;
        private final Countdown<F> countdown;
        private final /* synthetic */ KorolevStreamPublisher $outer;

        public StreamSubscription(KorolevStreamPublisher $outer, Stream<F, T> stream, Subscriber<? super T> subscriber) {
            this.stream = stream;
            this.subscriber = subscriber;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.countdown = new Countdown($outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1);
            Object object = syntax$.MODULE$.EffectOps(this.loop());
            syntax.EffectOps$.MODULE$.runAsync$extension(object, (Function1)((JProcedure1 & Serializable)arg_0 -> KorolevStreamPublisher.korolev$akka$util$KorolevStreamPublisher$StreamSubscription$$_$$lessinit$greater$$anonfun$1(subscriber, arg_0)), $outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1);
        }

        private F loop() {
            Object object = syntax$.MODULE$.EffectOps(this.countdown.decOrLock());
            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = syntax$.MODULE$.EffectOps(this.stream.pull());
                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)maybeItem -> {
                    Object object;
                    Option option = maybeItem;
                    if (option instanceof Some) {
                        Object item = ((Some)option).value();
                        this.subscriber.onNext(item);
                        object = this.loop();
                    } else if (None$.MODULE$.equals(option)) {
                        this.subscriber.onComplete();
                        object = Effect$.MODULE$.apply(this.$outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1).unit();
                    } else {
                        throw new MatchError((Object)option);
                    }
                    Object object2 = syntax$.MODULE$.EffectOps(object);
                    return syntax.EffectOps$.MODULE$.map$extension(object2, (Function1)((JProcedure1 & Serializable)KorolevStreamPublisher::korolev$akka$util$KorolevStreamPublisher$StreamSubscription$$_$loop$$anonfun$1$$anonfun$1$$anonfun$1), this.$outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1);
                }, this.$outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1);
            }, this.$outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1);
        }

        public void request(long n) {
            this.countdown.unsafeAdd(n);
        }

        public void cancel() {
            Object object = syntax$.MODULE$.EffectOps(this.stream.cancel());
            syntax.EffectOps$.MODULE$.runAsyncForget$extension(object, this.$outer.korolev$akka$util$KorolevStreamPublisher$$reporter, this.$outer.korolev$akka$util$KorolevStreamPublisher$$evidence$1);
        }

        public final /* synthetic */ KorolevStreamPublisher korolev$akka$util$KorolevStreamPublisher$StreamSubscription$$$outer() {
            return this.$outer;
        }
    }
}

