/*
 * Decompiled with CFR 0.152.
 */
package korolev.effect;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import korolev.effect.AsyncResourcePool$;
import korolev.effect.AsyncResourcePool$PoolItem$;
import korolev.effect.AsyncResourcePool$PoolState$;
import korolev.effect.Close;
import korolev.effect.Close$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Reporter;
import korolev.effect.syntax$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.TreeSet;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Right;

public class AsyncResourcePool<F, T> {
    public final String korolev$effect$AsyncResourcePool$$name;
    private final Function0<F> factory;
    public final Function0<F> korolev$effect$AsyncResourcePool$$currentNanos;
    private final int maxCount;
    public final Effect<F> korolev$effect$AsyncResourcePool$$evidence$1;
    private final Close<F, T> evidence$2;
    public final Reporter korolev$effect$AsyncResourcePool$$reporter;
    public final AsyncResourcePool$PoolItem$ PoolItem$lzy1;
    public final AsyncResourcePool$PoolState$ PoolState$lzy1;
    public final AtomicReference<PoolState> korolev$effect$AsyncResourcePool$$pool;
    private final long maxIdleTimeNanos;

    public static <F, K, T> Close<F, AsyncResourcePool<F, T>> asyncPoolMapClose(Effect<F> effect) {
        return AsyncResourcePool$.MODULE$.asyncPoolMapClose(effect);
    }

    public AsyncResourcePool(String name, Function0<Object> factory, Function0<Object> currentNanos, int maxCount, FiniteDuration maxIdleTime, Effect<F> evidence$1, Close<F, T> evidence$2, Reporter reporter) {
        this.korolev$effect$AsyncResourcePool$$name = name;
        this.factory = factory;
        this.korolev$effect$AsyncResourcePool$$currentNanos = currentNanos;
        this.maxCount = maxCount;
        this.korolev$effect$AsyncResourcePool$$evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.korolev$effect$AsyncResourcePool$$reporter = reporter;
        this.PoolItem$lzy1 = new AsyncResourcePool$PoolItem$(this);
        this.PoolState$lzy1 = new AsyncResourcePool$PoolState$(this);
        this.korolev$effect$AsyncResourcePool$$pool = new AtomicReference<PoolState>(this.PoolState().apply(this.PoolState().$lessinit$greater$default$1(), this.PoolState().$lessinit$greater$default$2(), this.PoolState().$lessinit$greater$default$3(), this.PoolState().$lessinit$greater$default$4(), this.PoolState().$lessinit$greater$default$5(), this.PoolState().$lessinit$greater$default$6()));
        this.maxIdleTimeNanos = maxIdleTime.toNanos();
    }

    public <R> F use(Function1<T, F> f) {
        return syntax$.MODULE$.EffectOps(this.borrow(), this.korolev$effect$AsyncResourcePool$$evidence$1).flatMap((Function1 & Serializable)borrow -> syntax$.MODULE$.EffectOps(f.apply(borrow.value()), this.korolev$effect$AsyncResourcePool$$evidence$1).flatMap((Function1 & Serializable)result -> syntax$.MODULE$.EffectOps(borrow.give(), this.korolev$effect$AsyncResourcePool$$evidence$1).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return result;
        })));
    }

    public F borrow() {
        return Effect$.MODULE$.apply(this.korolev$effect$AsyncResourcePool$$evidence$1).promise((JProcedure1 & Serializable)cb -> this.loop$2((Function1)cb));
    }

    public F onDispose() {
        return Effect$.MODULE$.apply(this.korolev$effect$AsyncResourcePool$$evidence$1).promise((JProcedure1 & Serializable)cb -> Effect$.MODULE$.apply(this.korolev$effect$AsyncResourcePool$$evidence$1).delay(() -> this.onDispose$$anonfun$1$$anonfun$1(cb)));
    }

    public F dispose() {
        return Effect$.MODULE$.apply(this.korolev$effect$AsyncResourcePool$$evidence$1).delayAsync(this::dispose$$anonfun$1);
    }

    public F cleanup() {
        return syntax$.MODULE$.EffectOps(this.korolev$effect$AsyncResourcePool$$currentNanos.apply(), this.korolev$effect$AsyncResourcePool$$evidence$1).flatMap((Function1 & Serializable)nanos -> this.cleanup$$anonfun$1(BoxesRunTime.unboxToLong((Object)nanos)));
    }

    public PoolState unsafeGetState() {
        return this.korolev$effect$AsyncResourcePool$$pool.get();
    }

    public final AsyncResourcePool$PoolItem$ PoolItem() {
        return this.PoolItem$lzy1;
    }

    public final AsyncResourcePool$PoolState$ PoolState() {
        return this.PoolState$lzy1;
    }

    private final void onCloseLoop$1(Object value) {
        PoolState ref;
        while (!(ref = this.korolev$effect$AsyncResourcePool$$pool.get()).itemIsClosed(value)) {
            List cbs;
            TreeSet closedItems = (TreeSet)ref.closedItems().$plus((Object)BoxesRunTime.boxToInteger((int)System.identityHashCode(value)));
            List items = ref.items().filter((Function1 & Serializable)_$3 -> !BoxesRunTime.equals(_$3.value(), (Object)value));
            Tuple2 tuple2 = ref.cbs().nonEmpty() ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)ref.total()), ref.cbs().tail()) : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(ref.total() - 1)), (Object)package$.MODULE$.Nil());
            int total = BoxesRunTime.unboxToInt((Object)tuple2._1());
            PoolState newState = ref.copy(total, (List<PoolItem>)items, cbs = (List)tuple2._2(), (TreeSet<Object>)closedItems, ref.copy$default$5(), ref.copy$default$6());
            if (!this.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref, newState)) continue;
            ref.cbs().headOption().foreach((Function1)(JProcedure1 & Serializable)cb -> syntax$.MODULE$.EffectOps(this.createNew$1(), this.korolev$effect$AsyncResourcePool$$evidence$1).runAsync(cb));
            break;
        }
    }

    private final Object createNew$1() {
        return syntax$.MODULE$.EffectOps(this.factory.apply(), this.korolev$effect$AsyncResourcePool$$evidence$1).map((Function1 & Serializable)value -> {
            this.korolev$effect$AsyncResourcePool$$reporter.debug("%s - Resource created", this.korolev$effect$AsyncResourcePool$$name);
            syntax$.MODULE$.EffectOps(Close$.MODULE$.apply(this.evidence$2).onClose(value), this.korolev$effect$AsyncResourcePool$$evidence$1).runAsync((JProcedure1 & Serializable)_$4 -> this.onCloseLoop$1(value));
            return new BorrowImpl(this, value);
        });
    }

    private final void loop$2(Function1 cb$1) {
        block4: {
            PoolState poolState;
            block5: {
                while (true) {
                    PoolState ref;
                    if ((poolState = this.korolev$effect$AsyncResourcePool$$pool.get()) != null) {
                        PoolState poolState2 = this.PoolState().unapply(poolState);
                        int n = poolState2._1();
                        List<PoolItem> list = poolState2._2();
                        List list2 = poolState2._3();
                        TreeSet<Object> treeSet = poolState2._4();
                        List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> list3 = poolState2._5();
                        boolean bl = poolState2._6();
                        if (list instanceof .colon.colon) {
                            .colon.colon colon2 = (.colon.colon)list;
                            List list4 = colon2.next$access$1();
                            PoolItem x = (PoolItem)colon2.head();
                            List xs = list4;
                            PoolState ref2 = poolState;
                            if (!this.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref2, ref2.copy(ref2.copy$default$1(), (List<PoolItem>)xs, ref2.copy$default$3(), ref2.copy$default$4(), ref2.copy$default$5(), ref2.copy$default$6()))) continue;
                            this.korolev$effect$AsyncResourcePool$$reporter.debug("%s - Return item from pool", this.korolev$effect$AsyncResourcePool$$name);
                            cb$1.apply((Object)package$.MODULE$.Right().apply((Object)new BorrowImpl(this, x.value())));
                            break block4;
                        }
                    }
                    if ((ref = poolState).total() >= this.maxCount) {
                        boolean bl;
                        List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> list;
                        TreeSet<Object> treeSet;
                        List<PoolItem> list5;
                        List list6 = ref.cbs().$colon$colon((Object)cb$1);
                        int n = ref.copy$default$1();
                        PoolState newState = ref.copy(n, list5 = ref.copy$default$2(), list6, treeSet = ref.copy$default$4(), list = ref.copy$default$5(), bl = ref.copy$default$6());
                        if (!this.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref, newState)) continue;
                        this.korolev$effect$AsyncResourcePool$$reporter.debug("%s - maxCount excited. save callback", this.korolev$effect$AsyncResourcePool$$name);
                        break block4;
                    }
                    PoolState ref3 = poolState;
                    if (!ref3.items().isEmpty()) break block5;
                    PoolState newState = ref3.copy(ref3.total() + 1, ref3.copy$default$2(), ref3.copy$default$3(), ref3.copy$default$4(), ref3.copy$default$5(), ref3.copy$default$6());
                    if (this.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref3, newState)) break;
                }
                this.korolev$effect$AsyncResourcePool$$reporter.debug("%s - Pool is empty. Try to create new item, increment total", this.korolev$effect$AsyncResourcePool$$name);
                syntax$.MODULE$.EffectOps(this.createNew$1(), this.korolev$effect$AsyncResourcePool$$evidence$1).runAsync(cb$1);
                break block4;
            }
            throw new MatchError((Object)poolState);
        }
    }

    private final void loop$3(Function1 cb$2) {
        block2: {
            PoolState ref;
            while (!(ref = this.korolev$effect$AsyncResourcePool$$pool.get()).disposed()) {
                boolean bl;
                TreeSet<Object> treeSet;
                List list;
                List<PoolItem> list2;
                List list3 = ref.disposeCbs().$colon$colon((Object)cb$2);
                int n = ref.copy$default$1();
                if (!this.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref, ref.copy(n, list2 = ref.copy$default$2(), list = ref.copy$default$3(), treeSet = ref.copy$default$4(), (List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>)list3, bl = ref.copy$default$6()))) {
                    continue;
                }
                break block2;
            }
            cb$2.apply((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }
    }

    private final void onDispose$$anonfun$1$$anonfun$1(Function1 cb$3) {
        this.loop$3(cb$3);
    }

    private static final void loop$4$$anonfun$1$$anonfun$1(PoolState ref$2, Right token$2) {
        ref$2.disposeCbs().foreach((Function1)(JProcedure1 & Serializable)_$6 -> _$6.apply((Object)token$2));
    }

    private final Object loop$4() {
        F f;
        block1: {
            PoolState ref;
            while (!(ref = this.korolev$effect$AsyncResourcePool$$pool.get()).disposed()) {
                if (!this.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref, ref.copy(ref.copy$default$1(), ref.copy$default$2(), ref.copy$default$3(), ref.copy$default$4(), ref.copy$default$5(), true))) continue;
                Right token = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                List effects = ref.items().map((Function1 & Serializable)item -> Close$.MODULE$.apply(this.evidence$2).close(item.value()));
                f = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.korolev$effect$AsyncResourcePool$$evidence$1).sequence(effects), this.korolev$effect$AsyncResourcePool$$evidence$1).flatMap((Function1 & Serializable)_$5 -> Effect$.MODULE$.apply(this.korolev$effect$AsyncResourcePool$$evidence$1).delay(() -> AsyncResourcePool.loop$4$$anonfun$1$$anonfun$1(ref, token)));
                break block1;
            }
            f = Effect$.MODULE$.apply(this.korolev$effect$AsyncResourcePool$$evidence$1).unit();
        }
        return f;
    }

    private final Object dispose$$anonfun$1() {
        return this.loop$4();
    }

    private static final /* synthetic */ boolean removeClosedSedLoop$1$$anonfun$1(PoolState ref$3, int elem) {
        return ref$3.closedItems().contains((Object)BoxesRunTime.boxToInteger((int)elem));
    }

    private final void removeClosedSedLoop$1(List obsoleteIds$2) {
        PoolState ref;
        while (obsoleteIds$2.forall((Function1)((JFunction1.mcZI.sp & Serializable)arg_0 -> AsyncResourcePool.removeClosedSedLoop$1$$anonfun$1(ref = this.korolev$effect$AsyncResourcePool$$pool.get(), arg_0)))) {
            TreeSet closedItems = (TreeSet)ref.closedItems().$minus$minus((IterableOnce)obsoleteIds$2);
            if (!this.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref, ref.copy(ref.copy$default$1(), ref.copy$default$2(), ref.copy$default$3(), (TreeSet<Object>)closedItems, ref.copy$default$5(), ref.copy$default$6()))) continue;
        }
    }

    private final Object loop$5(long nanos) {
        F f;
        block2: {
            block1: {
                List obsoleteIds;
                List obsolete;
                TreeSet closedSet;
                List items;
                int obsoleteCount;
                int total;
                PoolState newValue;
                PoolState ref;
                do {
                    ref = this.korolev$effect$AsyncResourcePool$$pool.get();
                    Function1 & Serializable itemsFilter = (Function1 & Serializable)item -> nanos - item.idle() < this.maxIdleTimeNanos;
                    items = ref.items().filter((Function1)itemsFilter);
                    if (items == ref.items()) break block1;
                    obsolete = ref.items().filterNot((Function1)itemsFilter);
                    obsoleteCount = obsolete.length();
                    obsoleteIds = obsolete.map((Function1 & Serializable)x -> System.identityHashCode(x.value()));
                    closedSet = (TreeSet)ref.closedItems().$plus$plus((IterableOnce)obsoleteIds);
                } while (!this.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref, newValue = ref.copy(total = ref.total() - obsoleteCount, (List<PoolItem>)items, ref.copy$default$3(), (TreeSet<Object>)closedSet, ref.copy$default$5(), ref.copy$default$6())));
                List xs = obsolete.map((Function1 & Serializable)item -> ((Close)Predef$.MODULE$.implicitly(this.evidence$2)).close(item.value()));
                f = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.korolev$effect$AsyncResourcePool$$evidence$1).sequence(xs), this.korolev$effect$AsyncResourcePool$$evidence$1).map((Function1 & Serializable)_$7 -> {
                    this.removeClosedSedLoop$1(obsoleteIds);
                    return obsoleteCount;
                });
                break block2;
            }
            f = Effect$.MODULE$.apply(this.korolev$effect$AsyncResourcePool$$evidence$1).pure(BoxesRunTime.boxToInteger((int)0));
        }
        return f;
    }

    private final /* synthetic */ Object cleanup$$anonfun$1(long nanos) {
        return this.loop$5(nanos);
    }

    public static interface Borrow<F, T> {
        public T value();

        public F give();
    }

    private class BorrowImpl
    implements Borrow<F, T> {
        private final Object value;
        private final AsyncResourcePool<F, T> $outer;

        public BorrowImpl(AsyncResourcePool $outer, T value) {
            this.value = value;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public F give() {
            return syntax$.MODULE$.EffectOps(this.$outer.korolev$effect$AsyncResourcePool$$currentNanos.apply(), this.$outer.korolev$effect$AsyncResourcePool$$evidence$1).map((JFunction1.mcVJ.sp & Serializable)nanos -> this.loop$1(nanos));
        }

        public final AsyncResourcePool<F, T> korolev$effect$AsyncResourcePool$BorrowImpl$$$outer() {
            return this.$outer;
        }

        private final void loop$1(long nanos) {
            block4: {
                Function1 cb;
                while (true) {
                    PoolState ref;
                    if ((ref = this.$outer.korolev$effect$AsyncResourcePool$$pool.get()).itemIsClosed(this.value())) {
                        boolean bl;
                        List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> list;
                        List list2;
                        List<PoolItem> list3;
                        int id = System.identityHashCode(this.value());
                        TreeSet treeSet = (TreeSet)ref.closedItems().$minus((Object)BoxesRunTime.boxToInteger((int)id));
                        int n = ref.copy$default$1();
                        PoolState newState = ref.copy(n, list3 = ref.copy$default$2(), list2 = ref.copy$default$3(), (TreeSet<Object>)treeSet, list = ref.copy$default$5(), bl = ref.copy$default$6());
                        if (!this.$outer.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref, newState)) continue;
                        this.$outer.korolev$effect$AsyncResourcePool$$reporter.debug("%s - Closed item finally removed from pool", this.$outer.korolev$effect$AsyncResourcePool$$name);
                        break block4;
                    }
                    if (ref.cbs().isEmpty()) {
                        boolean bl;
                        List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> list;
                        TreeSet<Object> treeSet;
                        List list4;
                        PoolItem item = this.$outer.PoolItem().apply(nanos, this.value());
                        List list5 = ref.items().$colon$colon((Object)item);
                        int n = ref.copy$default$1();
                        PoolState newState = ref.copy(n, (List<PoolItem>)list5, list4 = ref.copy$default$3(), treeSet = ref.copy$default$4(), list = ref.copy$default$5(), bl = ref.copy$default$6());
                        if (!this.$outer.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref, newState)) continue;
                        this.$outer.korolev$effect$AsyncResourcePool$$reporter.debug("%s - Item has gave back to pool", this.$outer.korolev$effect$AsyncResourcePool$$name);
                        break block4;
                    }
                    List list = ref.cbs();
                    if (!(list instanceof .colon.colon)) {
                        throw new MatchError(list);
                    }
                    .colon.colon colon2 = (.colon.colon)list;
                    List list6 = colon2.next$access$1();
                    Function1 cb2 = (Function1)colon2.head();
                    List restOfCbs = list6;
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)cb2, (Object)restOfCbs);
                    cb = (Function1)tuple2._1();
                    List restOfCbs2 = (List)tuple2._2();
                    PoolState newState = ref.copy(ref.copy$default$1(), ref.copy$default$2(), restOfCbs2, ref.copy$default$4(), ref.copy$default$5(), ref.copy$default$6());
                    if (this.$outer.korolev$effect$AsyncResourcePool$$pool.compareAndSet(ref, newState)) break;
                }
                this.$outer.korolev$effect$AsyncResourcePool$$reporter.debug("%s - Returned item transferred to next taker", this.$outer.korolev$effect$AsyncResourcePool$$name);
                cb.apply((Object)package$.MODULE$.Right().apply((Object)new BorrowImpl(this.$outer, this.value())));
            }
        }
    }

    public class PoolItem
    implements Product,
    Serializable {
        private final long idle;
        private final Object value;
        private final AsyncResourcePool<F, T> $outer;

        public PoolItem(AsyncResourcePool $outer, long idle, T value) {
            this.idle = idle;
            this.value = value;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.idle()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.value()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PoolItem)) return false;
            if (((PoolItem)object).korolev$effect$AsyncResourcePool$PoolItem$$$outer() != this.$outer) return false;
            PoolItem poolItem = (PoolItem)object;
            if (this.idle() != poolItem.idle()) return false;
            if (!BoxesRunTime.equals(this.value(), poolItem.value())) return false;
            if (!poolItem.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PoolItem;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "PoolItem";
        }

        public Object productElement(int n) {
            Long l;
            int n2 = n;
            if (0 == n2) {
                l = BoxesRunTime.boxToLong((long)this._1());
            } else if (1 == n2) {
                l = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return l;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "idle";
            } else if (1 == n2) {
                string = "value";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public long idle() {
            return this.idle;
        }

        public T value() {
            return this.value;
        }

        public PoolItem copy(long idle, T value) {
            return new PoolItem(this.$outer, idle, value);
        }

        public long copy$default$1() {
            return this.idle();
        }

        public T copy$default$2() {
            return this.value();
        }

        public long _1() {
            return this.idle();
        }

        public T _2() {
            return this.value();
        }

        public final AsyncResourcePool<F, T> korolev$effect$AsyncResourcePool$PoolItem$$$outer() {
            return this.$outer;
        }
    }

    public class PoolState
    implements Product,
    Serializable {
        private final int total;
        private final List items;
        private final List cbs;
        private final TreeSet closedItems;
        private final List disposeCbs;
        private final boolean disposed;
        private final AsyncResourcePool<F, T> $outer;

        public PoolState(AsyncResourcePool $outer, int total, List<PoolItem> items, List<Function1<Either<Throwable, Borrow<F, T>>, BoxedUnit>> cbs, TreeSet<Object> closedItems, List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> disposeCbs, boolean disposed) {
            this.total = total;
            this.items = items;
            this.cbs = cbs;
            this.closedItems = closedItems;
            this.disposeCbs = disposeCbs;
            this.disposed = disposed;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.total());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.items()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.cbs()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.closedItems()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.disposeCbs()));
            n = Statics.mix((int)n, (int)(this.disposed() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PoolState)) return false;
            if (((PoolState)object).korolev$effect$AsyncResourcePool$PoolState$$$outer() != this.$outer) return false;
            PoolState poolState = (PoolState)object;
            if (this.total() != poolState.total()) return false;
            if (this.disposed() != poolState.disposed()) return false;
            List<PoolItem> list = this.items();
            List<PoolItem> list2 = poolState.items();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            List list3 = this.cbs();
            List list4 = poolState.cbs();
            if (list3 == null) {
                if (list4 != null) {
                    return false;
                }
            } else if (!list3.equals(list4)) return false;
            TreeSet<Object> treeSet = this.closedItems();
            TreeSet<Object> treeSet2 = poolState.closedItems();
            if (treeSet == null) {
                if (treeSet2 != null) {
                    return false;
                }
            } else if (!treeSet.equals(treeSet2)) return false;
            List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> list5 = this.disposeCbs();
            List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> list6 = poolState.disposeCbs();
            if (list5 == null) {
                if (list6 != null) {
                    return false;
                }
            } else if (!list5.equals(list6)) return false;
            if (!poolState.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PoolState;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "PoolState";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._6());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "total";
                    break;
                }
                case 1: {
                    string = "items";
                    break;
                }
                case 2: {
                    string = "cbs";
                    break;
                }
                case 3: {
                    string = "closedItems";
                    break;
                }
                case 4: {
                    string = "disposeCbs";
                    break;
                }
                case 5: {
                    string = "disposed";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public int total() {
            return this.total;
        }

        public List<PoolItem> items() {
            return this.items;
        }

        public List<Function1<Either<Throwable, Borrow<F, T>>, BoxedUnit>> cbs() {
            return this.cbs;
        }

        public TreeSet<Object> closedItems() {
            return this.closedItems;
        }

        public List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> disposeCbs() {
            return this.disposeCbs;
        }

        public boolean disposed() {
            return this.disposed;
        }

        public boolean itemIsClosed(T value) {
            return this.closedItems().contains((Object)BoxesRunTime.boxToInteger((int)System.identityHashCode(value)));
        }

        public PoolState copy(int total, List<PoolItem> items, List<Function1<Either<Throwable, Borrow<F, T>>, BoxedUnit>> cbs, TreeSet<Object> closedItems, List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> disposeCbs, boolean disposed) {
            return new PoolState(this.$outer, total, items, cbs, closedItems, disposeCbs, disposed);
        }

        public int copy$default$1() {
            return this.total();
        }

        public List<PoolItem> copy$default$2() {
            return this.items();
        }

        public List<Function1<Either<Throwable, Borrow<F, T>>, BoxedUnit>> copy$default$3() {
            return this.cbs();
        }

        public TreeSet<Object> copy$default$4() {
            return this.closedItems();
        }

        public List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> copy$default$5() {
            return this.disposeCbs();
        }

        public boolean copy$default$6() {
            return this.disposed();
        }

        public int _1() {
            return this.total();
        }

        public List<PoolItem> _2() {
            return this.items();
        }

        public List<Function1<Either<Throwable, Borrow<F, T>>, BoxedUnit>> _3() {
            return this.cbs();
        }

        public TreeSet<Object> _4() {
            return this.closedItems();
        }

        public List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> _5() {
            return this.disposeCbs();
        }

        public boolean _6() {
            return this.disposed();
        }

        public final AsyncResourcePool<F, T> korolev$effect$AsyncResourcePool$PoolState$$$outer() {
            return this.$outer;
        }
    }
}

