/*
 * Decompiled with CFR 0.152.
 */
package korolev.http;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import korolev.data.BytesLike;
import korolev.effect.Decoder;
import korolev.effect.Decoder$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Stream;
import korolev.effect.io.RawDataSocket$;
import korolev.effect.syntax$;
import korolev.http.protocol.Http11;
import korolev.http.protocol.WebSocketProtocol;
import korolev.http.protocol.WebSocketProtocol$Intention$;
import korolev.web.Path;
import korolev.web.PathAndQuery;
import korolev.web.Request;
import korolev.web.Request$;
import korolev.web.Response;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxesRunTime;

public final class HttpClient$ {
    public static HttpClient$ MODULE$;

    static {
        new HttpClient$();
    }

    public <F, B> F apply(String host, int port, Request<Stream<F, B>> request, int bufferSize, Effect<F> evidence$1, BytesLike<B> evidence$2, ExecutionContext executor) {
        Http11 http11 = new Http11(evidence$2);
        return (F)syntax$.MODULE$.EffectOps(RawDataSocket$.MODULE$.connect(new InetSocketAddress(host, port), ByteBuffer.allocate(bufferSize), RawDataSocket$.MODULE$.connect$default$3(), evidence$1, evidence$2), evidence$1).flatMap((Function1 & Serializable & scala.Serializable)socket -> syntax$.MODULE$.EffectOps(http11.renderRequest(request.withHeader("Host", host), evidence$1), evidence$1).flatMap((Function1 & Serializable & scala.Serializable)requestStream -> syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(requestStream.foreach((Function1 & Serializable & scala.Serializable)bytes -> socket.write(bytes)), evidence$1).start(executor), evidence$1).flatMap((Function1 & Serializable & scala.Serializable)writeBytesFiber -> syntax$.MODULE$.EffectOps(http11.decodeResponse(Decoder$.MODULE$.apply(socket.stream(), evidence$1), evidence$1).pull(), evidence$1).flatMap((Function1 & Serializable & scala.Serializable)maybeResponse -> {
            Object object;
            Option option = maybeResponse;
            if (option instanceof Some) {
                Stream consumableBody;
                Some some = (Some)option;
                Response response = (Response)some.value();
                Tuple2 tuple2 = ((Stream)response.body()).handleConsumed();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object consumed = tuple2._1();
                Stream consumableBody2 = (Stream)tuple2._2();
                Tuple2 tuple22 = new Tuple2(consumed, (Object)consumableBody2);
                Tuple2 tuple23 = tuple22;
                Object consumed2 = tuple23._1();
                Stream x$1 = consumableBody = (Stream)tuple23._2();
                Response.Status x$2 = response.copy$default$1();
                Seq x$3 = response.copy$default$3();
                Option x$4 = response.copy$default$4();
                object = syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(consumed2, evidence$1).after((Function0 & Serializable & scala.Serializable)() -> writeBytesFiber.join()), evidence$1).after((Function0 & Serializable & scala.Serializable)() -> socket.stream().cancel()), evidence$1).start(executor), evidence$1).as((Object)response.copy(x$2, (Object)x$1, x$3, x$4));
            } else if (None$.MODULE$.equals(option)) {
                object = Effect$.MODULE$.apply(evidence$1).fail((Throwable)new IllegalStateException("Peer has closed connection before sending response."));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        }))));
    }

    public <F, B> int apply$default$4() {
        return 8096;
    }

    public <F, B> F webSocket(String host, int port, Path path, Stream<F, WebSocketProtocol.Frame<B>> outgoingFrames, Map<String, String> params, Map<String, String> cookie, Map<String, String> headers, Effect<F> evidence$3, BytesLike<B> evidence$4, ExecutionContext executor) {
        WebSocketProtocol webSocketProtocol = new WebSocketProtocol(evidence$4);
        return (F)syntax$.MODULE$.EffectOps(WebSocketProtocol$Intention$.MODULE$.random(evidence$3), evidence$3).flatMap((Function1 & Serializable & scala.Serializable)intention -> {
            Stream encodedOutgoingFrames = outgoingFrames.map((Function1 & Serializable & scala.Serializable)frame -> webSocketProtocol.encodeFrame((WebSocketProtocol.Frame)frame, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)123))));
            Request requestRaw = new Request((Request.Method)Request.Method$.Get$.MODULE$, (PathAndQuery)path, headers.toSeq(), (Option)None$.MODULE$, (Object)encodedOutgoingFrames, Request$.MODULE$.apply$default$6());
            Request requestWithParams = (Request)params.foldLeft((Object)requestRaw, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                Request acc;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        acc = (Request)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Request request = acc.withParam(k, v);
                return request;
            });
            Request requestWithCookie = (Request)cookie.foldLeft((Object)requestWithParams, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2;
                Request acc;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$2, x1$2);
                        if (tuple22 == null) break block2;
                        acc = (Request)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Request request = acc.withCookie(k, v);
                return request;
            });
            Request requestWithIntention = webSocketProtocol.addIntention(requestWithCookie, (WebSocketProtocol.Intention)intention);
            return syntax$.MODULE$.EffectOps(MODULE$.apply(host, port, requestWithIntention, MODULE$.apply$default$4(), evidence$3, evidence$4, executor), evidence$3).map((Function1 & Serializable & scala.Serializable)rawResponse -> {
                Decoder frames;
                Decoder frameDecoder = Decoder$.MODULE$.apply((Stream)rawResponse.body(), evidence$3);
                Decoder x$1 = frames = webSocketProtocol.mergeFrames(webSocketProtocol.decodeFrames(frameDecoder, evidence$3), evidence$3);
                Response.Status x$2 = rawResponse.copy$default$1();
                Seq x$3 = rawResponse.copy$default$3();
                Option x$4 = rawResponse.copy$default$4();
                return rawResponse.copy(x$2, x$1, x$3, x$4);
            });
        });
    }

    public <F, B> Map<String, String> webSocket$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public <F, B> Map<String, String> webSocket$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public <F, B> Map<String, String> webSocket$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    private HttpClient$() {
        MODULE$ = this;
    }
}

