/*
 * Decompiled with CFR 0.152.
 */
package korolev.http;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import korolev.data.BytesLike;
import korolev.effect.AsyncResourcePool;
import korolev.effect.Decoder;
import korolev.effect.Decoder$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Reporter;
import korolev.effect.Scheduler;
import korolev.effect.Stream;
import korolev.effect.io.DataSocket;
import korolev.effect.io.DataSocket$;
import korolev.effect.io.RawDataSocket;
import korolev.effect.io.RawDataSocket$;
import korolev.effect.io.SecureDataSocket;
import korolev.effect.io.SecureDataSocket$;
import korolev.effect.syntax$;
import korolev.http.HttpClient$;
import korolev.http.protocol.Http11;
import korolev.http.protocol.WebSocketProtocol;
import korolev.http.protocol.WebSocketProtocol$Intention$;
import korolev.web.Headers$;
import korolev.web.PathAndQuery;
import korolev.web.PathAndQuery$;
import korolev.web.Request;
import korolev.web.Request$;
import korolev.web.Response;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\rh\u0001\u0002\u00180\u0001QB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!y\u0006A!A!\u0002\u0013\u0001\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011%\u0004!\u0011!Q\u0001\n)D\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\u000b\u00033\u0001!1!Q\u0001\f\u0005m\u0001BCA\u0011\u0001\t\r\t\u0015a\u0003\u0002$!Q\u0011Q\u0007\u0001\u0003\u0002\u0003\u0006Y!a\u000e\t\u0015\u0005}\u0002A!A!\u0002\u0017\t\t\u0005C\u0004\u0002H\u0001!I!!\u0013\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007B\u0002\u0019\u0001\t\u0003\t)\u000f\u0003\u00041\u0001\u0011%\u00111\u001e\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011i\u0007\u0001C\u0001\u0005_BqA!\u001c\u0001\t\u0003\u0011I\bC\u0004\u0003n\u0001!IA!\"\t\u000f\tu\u0005\u0001\"\u0003\u0003 \"9!1\u0015\u0001\u0005\n\t\u0015\u0006b\u0002B[\u0001\u0011%!q\u0017\u0005\n\u0005\u000b\u0004!\u0019!C\u0005\u0005\u000fD\u0001Ba4\u0001A\u0003%!\u0011\u001a\u0005\n\u0005#\u0004!\u0019!C\u0005\u0005'D\u0001Ba7\u0001A\u0003%!Q\u001b\u0005\n\u0005;\u0004!\u0019!C\u0005\u0005?D\u0001B!>\u0001A\u0003%!\u0011\u001d\u0005\n\u0005o\u0004!\u0019!C\u0005\u0005sD\u0001Ba@\u0001A\u0003%!1`\u0004\b\u0007\u0003y\u0003\u0012AB\u0002\r\u0019qs\u0006#\u0001\u0004\u0006!9\u0011q\t\u0012\u0005\u0002\r\u001d\u0001BCB\u0005E!\u0015\r\u0011\"\u0003\u0004\f!911\u0003\u0012\u0005\u0002\rU\u0001\"CB-EE\u0005I\u0011AB.\u0011%\u0019YHII\u0001\n\u0003\u0019i\bC\u0005\u0004\f\n\n\n\u0011\"\u0001\u0004\u000e\"I11\u0014\u0012\u0012\u0002\u0013\u00051Q\u0014\u0005\n\u0007O\u0013\u0013\u0013!C\u0001\u0007SC\u0011ba.##\u0003%\ta!/\t\u0013\r\u001d'%%A\u0005\u0002\r%\u0007\"CBjEE\u0005I\u0011ABk\u0005)AE\u000f\u001e9DY&,g\u000e\u001e\u0006\u0003aE\nA\u0001\u001b;ua*\t!'A\u0004l_J|G.\u001a<\u0004\u0001U!Q'`A\u0019'\t\u0001a\u0007\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004B]f\u0014VMZ\u0001\u0005]\u0006lW\r\u0005\u0002?\u000b:\u0011qh\u0011\t\u0003\u0001bj\u0011!\u0011\u0006\u0003\u0005N\na\u0001\u0010:p_Rt\u0014B\u0001#9\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011C\u0014aC7bq&#G.\u001a+j[\u0016\u0004\"AS(\u000e\u0003-S!\u0001T'\u0002\u0011\u0011,(/\u0019;j_:T!A\u0014\u001d\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002Q\u0017\nqa)\u001b8ji\u0016$UO]1uS>t\u0017\u0001G7bq\u000e{gN\\3di&|gn\u001d)fe\u0006#GM]3tgB\u0011qgU\u0005\u0003)b\u00121!\u00138u\u0003A\u0011Gn\\2lS:<W\t_3dkR|'\u000f\u0005\u0002X;6\t\u0001L\u0003\u0002O3*\u0011!lW\u0001\u0005kRLGNC\u0001]\u0003\u0011Q\u0017M^1\n\u0005yC&\u0001C#yK\u000e,Ho\u001c:\u0002\u000b\u001d\u0014x.\u001e9\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017\u0001C2iC:tW\r\\:\u000b\u0005\u0015\\\u0016a\u00018j_&\u0011qM\u0019\u0002\u0019\u0003NLhn\u00195s_:|Wo]\"iC:tW\r\\$s_V\u0004\u0018A\u00032vM\u001a,'oU5{K\u0006Q1o\u001d7D_:$X\r\u001f;\u0011\u0005-\u0014X\"\u00017\u000b\u00055t\u0017aA:tY*\u0011q\u000e]\u0001\u0004]\u0016$(\"A9\u0002\u000b)\fg/\u0019=\n\u0005Md'AC*T\u0019\u000e{g\u000e^3yi\u0006a1\r\\3b]V\u0004H+[2lgB)a/_>\u0002\u00145\tqO\u0003\u0002yc\u00051QM\u001a4fGRL!A_<\u0003\rM#(/Z1n!\taX\u0010\u0004\u0001\u0005\u000by\u0004!\u0019A@\u0003\u0003\u0019+B!!\u0001\u0002\u0010E!\u00111AA\u0005!\r9\u0014QA\u0005\u0004\u0003\u000fA$a\u0002(pi\"Lgn\u001a\t\u0004o\u0005-\u0011bAA\u0007q\t\u0019\u0011I\\=\u0005\u000f\u0005EQP1\u0001\u0002\u0002\t\tq\fE\u00028\u0003+I1!a\u00069\u0005\u0011)f.\u001b;\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0003w\u0003;Y\u0018bAA\u0010o\n1QI\u001a4fGR\f!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\t)#a\u000b\u000205\u0011\u0011q\u0005\u0006\u0004\u0003S\t\u0014\u0001\u00023bi\u0006LA!!\f\u0002(\tI!)\u001f;fg2K7.\u001a\t\u0004y\u0006EBaBA\u001a\u0001\t\u0007\u0011\u0011\u0001\u0002\u0002\u0005\u0006AQ\r_3dkR|'\u000f\u0005\u0003\u0002:\u0005mR\"A'\n\u0007\u0005uRJ\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006A!/\u001a9peR,'\u000fE\u0002w\u0003\u0007J1!!\u0012x\u0005!\u0011V\r]8si\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\n\u0002L\u0005e\u00131LA/\u0003?\n\t'a\u0019\u0002f\u0005\u001dDCCA'\u0003#\n\u0019&!\u0016\u0002XA1\u0011q\n\u0001|\u0003_i\u0011a\f\u0005\b\u00033i\u00019AA\u000e\u0011\u001d\t\t#\u0004a\u0002\u0003GAq!!\u000e\u000e\u0001\b\t9\u0004C\u0004\u0002@5\u0001\u001d!!\u0011\t\u000bqj\u0001\u0019A\u001f\t\u000b!k\u0001\u0019A%\t\u000bEk\u0001\u0019\u0001*\t\u000bUk\u0001\u0019\u0001,\t\u000b}k\u0001\u0019\u00011\t\u000b!l\u0001\u0019\u0001*\t\u000b%l\u0001\u0019\u00016\t\u000bQl\u0001\u0019A;\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u00055\u0014QPAH\u0003;\u000bI,!3\u0011\tql\u0018q\u000e\t\u0007\u0003c\n9(a\u001f\u000e\u0005\u0005M$bAA;c\u0005\u0019q/\u001a2\n\t\u0005e\u00141\u000f\u0002\t%\u0016\u001c\bo\u001c8tKB)a/_>\u00020!9\u0011q\u0010\bA\u0002\u0005\u0005\u0015AB7fi\"|G\r\u0005\u0003\u0002\u0004\u0006%e\u0002BA9\u0003\u000bKA!a\"\u0002t\u00059!+Z9vKN$\u0018\u0002BAF\u0003\u001b\u0013a!T3uQ>$'\u0002BAD\u0003gBq!!%\u000f\u0001\u0004\t\u0019*A\u0002ve&\u0004B!!&\u0002\u001a6\u0011\u0011q\u0013\u0006\u0003_nKA!a'\u0002\u0018\n\u0019QKU%\t\u000f\u0005}e\u00021\u0001\u0002\"\u00069\u0001.Z1eKJ\u001c\bCBAR\u0003[\u000b\u0019L\u0004\u0003\u0002&\u0006%fb\u0001!\u0002(&\t\u0011(C\u0002\u0002,b\nq\u0001]1dW\u0006<W-\u0003\u0003\u00020\u0006E&aA*fc*\u0019\u00111\u0016\u001d\u0011\u000b]\n),P\u001f\n\u0007\u0005]\u0006H\u0001\u0004UkBdWM\r\u0005\b\u0003ws\u0001\u0019AA_\u00035\u0019wN\u001c;f]RdUM\\4uQB)q'a0\u0002D&\u0019\u0011\u0011\u0019\u001d\u0003\r=\u0003H/[8o!\r9\u0014QY\u0005\u0004\u0003\u000fD$\u0001\u0002'p]\u001eDq!a3\u000f\u0001\u0004\tY(\u0001\u0003c_\u0012L\u0018!\u00025uiB\u001cHCBA7\u0003#\fY\u000eC\u0004\u0002T>\u0001\r!!6\u0002\u000f\u0005$GM]3tgB!\u0011QSAl\u0013\u0011\tI.a&\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000fC\u0004\u0002^>\u0001\r!a8\u0002\u000fI,\u0017/^3tiB1\u0011\u0011OAq\u0003wJA!a9\u0002t\t9!+Z9vKN$HCBA7\u0003O\fI\u000fC\u0004\u0002TB\u0001\r!!6\t\u000f\u0005u\u0007\u00031\u0001\u0002`RA\u0011QNAw\u0005'\u00119\u0002C\u0004\u0002pF\u0001\r!!=\u0002\r\t|'O]8x!\u001d\t\u0019P!\u0001|\u0005\u000fqA!!>\u0002~:!\u0011q_A~\u001d\r\u0001\u0015\u0011`\u0005\u0002e%\u0011\u00010M\u0005\u0004\u0003\u007f<\u0018!E!ts:\u001c'+Z:pkJ\u001cW\rU8pY&!!1\u0001B\u0003\u0005\u0019\u0011uN\u001d:po*\u0019\u0011q`<\u0011\u000f\t%!qB>\u000205\u0011!1\u0002\u0006\u0004\u0005\u001b9\u0018AA5p\u0013\u0011\u0011\tBa\u0003\u0003\u0015\u0011\u000bG/Y*pG.,G\u000f\u0003\u0004\u0003\u0016E\u0001\r!P\u0001\u0005Q>\u001cH\u000fC\u0004\u0002^F\u0001\r!a8\u0002\u001fM,7-\u001e:f/\u0016\u00147k\\2lKR$BB!\b\u0003F\t\u001d#\u0011\u000bB1\u0005W\u0002B\u0001`?\u0003 A1\u0011\u0011OA<\u0005C\u0001RA^=|\u0005G\u0001bA!\n\u0003@\u0005=b\u0002\u0002B\u0014\u0005sqAA!\u000b\u000349!!1\u0006B\u0018\u001d\u0011\t9P!\f\n\u0005A\n\u0014b\u0001B\u0019_\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u00036\t]\u0012!E,fEN{7m[3u!J|Go\\2pY*\u0019!\u0011G\u0018\n\t\tm\"QH\u0001\u0006\rJ\fW.\u001a\u0006\u0005\u0005k\u00119$\u0003\u0003\u0003B\t\r#AB'fe\u001e,GM\u0003\u0003\u0003<\tu\u0002bBAj%\u0001\u0007\u0011Q\u001b\u0005\b\u0005\u0013\u0012\u0002\u0019\u0001B&\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u0005E$QJ\u0005\u0005\u0005\u001f\n\u0019H\u0001\u0007QCRD\u0017I\u001c3Rk\u0016\u0014\u0018\u0010C\u0004\u0003TI\u0001\rA!\u0016\u0002\u001d=,HoZ8j]\u001e4%/Y7fgB)a/_>\u0003XA1!\u0011\fB/\u0003_qAAa\u0017\u000345\u0011!qG\u0005\u0005\u0005?\u0012iDA\u0003Ge\u0006lW\rC\u0004\u0003dI\u0001\rA!\u001a\u0002\r\r|wn[5f!\u0015q$qM\u001f>\u0013\r\u0011Ig\u0012\u0002\u0004\u001b\u0006\u0004\bbBAP%\u0001\u0007!QM\u0001\no\u0016\u00147k\\2lKR$\"B!\b\u0003r\tM$Q\u000fB<\u0011\u001d\t\tj\u0005a\u0001\u0003'CqAa\u0015\u0014\u0001\u0004\u0011)\u0006C\u0004\u0003dM\u0001\rA!\u001a\t\u000f\u0005}5\u00031\u0001\u0003fQa!Q\u0004B>\u0005{\u0012yH!!\u0003\u0004\"9\u00111\u001b\u000bA\u0002\u0005U\u0007b\u0002B%)\u0001\u0007!1\n\u0005\b\u0005'\"\u0002\u0019\u0001B+\u0011\u001d\u0011\u0019\u0007\u0006a\u0001\u0005KBq!a(\u0015\u0001\u0004\u0011)\u0007\u0006\b\u0003\b\nE%1\u0013BK\u0005/\u0013IJa'\u0011\tql(\u0011\u0012\t\u0007\u0003c\n9Ha#\u0011\u000bYL8P!$\u0011\r\t=%qHA\u0018\u001d\u0011\u0011IF!\u000f\t\u000f\u0005=X\u00031\u0001\u0002r\"1!QC\u000bA\u0002uBqA!\u0013\u0016\u0001\u0004\u0011Y\u0005C\u0004\u0003TU\u0001\rA!\u0016\t\u000f\t\rT\u00031\u0001\u0003f!9\u0011qT\u000bA\u0002\t\u0015\u0014!\u00039r\rJ|W.\u0016:j)\u0011\u0011YE!)\t\u000f\u0005Ee\u00031\u0001\u0002\u0014\u0006\tB/Y6f%\u0006<8i\u001c8oK\u000e$\u0018n\u001c8\u0015\t\t\u001d&1\u0017\t\u0005yv\u0014I\u000bE\u0004\u0003,\n\u00051P!,\u000f\u0007Y\fi\u0010E\u0004\u0003\n\t=60a\f\n\t\tE&1\u0002\u0002\u000e%\u0006<H)\u0019;b'>\u001c7.\u001a;\t\u000f\u0005Mw\u00031\u0001\u0002V\u0006!B/Y6f'\u0016\u001cWO]3D_:tWm\u0019;j_:$BA!/\u0003DB!A0 B^!\u001d\u0011YK!\u0001|\u0005{\u0003rA!\u0003\u0003@n\fy#\u0003\u0003\u0003B\n-!\u0001E*fGV\u0014X\rR1uCN{7m[3u\u0011\u001d\t\u0019\u000e\u0007a\u0001\u0003+\fa\u0001\u001b;uaF\nTC\u0001Be!\u0019\u0011YFa3\u00020%!!Q\u001aB\u001c\u0005\u0019AE\u000f\u001e92c\u00059\u0001\u000e\u001e;qcE\u0002\u0013!E<fEN{7m[3u!J|Go\\2pYV\u0011!Q\u001b\t\u0007\u00057\u00129.a\f\n\t\te'q\u0007\u0002\u0012/\u0016\u00147k\\2lKR\u0004&o\u001c;pG>d\u0017AE<fEN{7m[3u!J|Go\\2pY\u0002\n1C]1x\u0007>tg.Z2uS>t7\u000fU8pYN,\"A!9\u0011\u0011\t\r(1^Ak\u0005_l!A!:\u000b\u00079\u00139OC\u0002\u0003jb\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iO!:\u0003\u000fQ\u0013\u0018.Z'baB1aO!=|\u0005[K1Aa=x\u0005E\t5/\u001f8d%\u0016\u001cx.\u001e:dKB{w\u000e\\\u0001\u0015e\u0006<8i\u001c8oK\u000e$\u0018n\u001c8t!>|Gn\u001d\u0011\u0002-M,7-\u001e:f\u0007>tg.Z2uS>t7\u000fU8pYN,\"Aa?\u0011\u0011\t\r(1^Ak\u0005{\u0004bA\u001eByw\nu\u0016aF:fGV\u0014XmQ8o]\u0016\u001cG/[8ogB{w\u000e\\:!\u0003)AE\u000f\u001e9DY&,g\u000e\u001e\t\u0004\u0003\u001f\u00123C\u0001\u00127)\t\u0019\u0019!A\feK\u001a\fW\u000f\u001c;CY>\u001c7.\u001b8h\u000bb,7-\u001e;peV\u00111Q\u0002\t\u0004/\u000e=\u0011bAB\t1\nyQ\t_3dkR|'oU3sm&\u001cW-\u0001\u0004de\u0016\fG/Z\u000b\u0007\u0007/\u0019ib!\u000b\u0015%\re1QIB$\u0007\u0013\u001aYea\u0014\u0004R\rM3q\u000b\u000b\r\u00077\u0019Yc!\r\u0004<\r\u000531\t\t\u0006y\u000eu11\u0005\u0003\u0007}\u0016\u0012\raa\b\u0016\t\u0005\u00051\u0011\u0005\u0003\t\u0003#\u0019iB1\u0001\u0002\u0002A9\u0011q\n\u0001\u0004&\r\u001d\u0002c\u0001?\u0004\u001eA\u0019Ap!\u000b\u0005\u000f\u0005MRE1\u0001\u0002\u0002!I1QF\u0013\u0002\u0002\u0003\u000f1qF\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004#\u0002<\u0002\u001e\r\u0015\u0002\"CB\u001aK\u0005\u0005\t9AB\u001b\u0003))g/\u001b3f]\u000e,G\u0005\u000e\t\u0006m\u000e]2QE\u0005\u0004\u0007s9(!C*dQ\u0016$W\u000f\\3s\u0011%\u0019i$JA\u0001\u0002\b\u0019y$\u0001\u0006fm&$WM\\2fIU\u0002b!!\n\u0002,\r\u001d\u0002bBA\u001bK\u0001\u000f\u0011q\u0007\u0005\b\u0003\u007f)\u00039AA!\u0011\u001daT\u0005%AA\u0002uBq\u0001S\u0013\u0011\u0002\u0003\u0007\u0011\nC\u0004RKA\u0005\t\u0019\u0001*\t\u0011\r5S\u0005%AA\u0002%\u000b1\u0003]8pY\u000ecW-\u00198va&sG/\u001a:wC2Dq!V\u0013\u0011\u0002\u0003\u0007a\u000bC\u0004`KA\u0005\t\u0019\u00011\t\u0011\rUS\u0005%AA\u0002I\u000b!#\u001b8d_6Lgn\u001a\"vM\u001a,'oU5{K\"9\u0011.\nI\u0001\u0002\u0004Q\u0017\u0001E2sK\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00132+\u0019\u0019ifa\u001d\u0004zU\u00111q\f\u0016\u0004{\r\u00054FAB2!\u0011\u0019)ga\u001c\u000e\u0005\r\u001d$\u0002BB5\u0007W\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r5\u0004(\u0001\u0006b]:|G/\u0019;j_:LAa!\u001d\u0004h\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\ry4#\u0019AB;+\u0011\t\taa\u001e\u0005\u0011\u0005E11\u000fb\u0001\u0003\u0003!q!a\r'\u0005\u0004\t\t!\u0001\tde\u0016\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU11qPBB\u0007\u0013+\"a!!+\u0007%\u001b\t\u0007\u0002\u0004\u007fO\t\u00071QQ\u000b\u0005\u0003\u0003\u00199\t\u0002\u0005\u0002\u0012\r\r%\u0019AA\u0001\t\u001d\t\u0019d\nb\u0001\u0003\u0003\t\u0001c\u0019:fCR,G\u0005Z3gCVdG\u000fJ\u001a\u0016\r\r=51SBM+\t\u0019\tJK\u0002S\u0007C\"aA \u0015C\u0002\rUU\u0003BA\u0001\u0007/#\u0001\"!\u0005\u0004\u0014\n\u0007\u0011\u0011\u0001\u0003\b\u0003gA#\u0019AA\u0001\u0003A\u0019'/Z1uK\u0012\"WMZ1vYR$C'\u0006\u0004\u0004\u0000\r}5Q\u0015\u0003\u0007}&\u0012\ra!)\u0016\t\u0005\u000511\u0015\u0003\t\u0003#\u0019yJ1\u0001\u0002\u0002\u00119\u00111G\u0015C\u0002\u0005\u0005\u0011\u0001E2sK\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00136+\u0019\u0019Yka,\u00046V\u00111Q\u0016\u0016\u0004-\u000e\u0005DA\u0002@+\u0005\u0004\u0019\t,\u0006\u0003\u0002\u0002\rMF\u0001CA\t\u0007_\u0013\r!!\u0001\u0005\u000f\u0005M\"F1\u0001\u0002\u0002\u0005\u00012M]3bi\u0016$C-\u001a4bk2$HEN\u000b\u0007\u0007w\u001byl!2\u0016\u0005\ru&f\u00011\u0004b\u00111ap\u000bb\u0001\u0007\u0003,B!!\u0001\u0004D\u0012A\u0011\u0011CB`\u0005\u0004\t\t\u0001B\u0004\u00024-\u0012\r!!\u0001\u0002!\r\u0014X-\u0019;fI\u0011,g-Y;mi\u0012:TCBBH\u0007\u0017\u001c\t\u000e\u0002\u0004\u007fY\t\u00071QZ\u000b\u0005\u0003\u0003\u0019y\r\u0002\u0005\u0002\u0012\r-'\u0019AA\u0001\t\u001d\t\u0019\u0004\fb\u0001\u0003\u0003\t\u0001c\u0019:fCR,G\u0005Z3gCVdG\u000f\n\u001d\u0016\r\r]71\\Bq+\t\u0019INK\u0002k\u0007C\"aA`\u0017C\u0002\ruW\u0003BA\u0001\u0007?$\u0001\"!\u0005\u0004\\\n\u0007\u0011\u0011\u0001\u0003\b\u0003gi#\u0019AA\u0001\u0001")
public class HttpClient<F, B> {
    private final String name;
    private final FiniteDuration maxIdleTime;
    private final int maxConnectionsPerAddress;
    private final Executor blockingExecutor;
    private final AsynchronousChannelGroup group;
    private final int bufferSize;
    private final SSLContext sslContext;
    private final Effect<F> evidence$1;
    private final BytesLike<B> evidence$2;
    private final ExecutionContext executor;
    private final Reporter reporter;
    private final Http11<B> http11;
    private final WebSocketProtocol<B> webSocketProtocol;
    private final TrieMap<InetSocketAddress, AsyncResourcePool<F, RawDataSocket<F, B>>> rawConnectionsPools;
    private final TrieMap<InetSocketAddress, AsyncResourcePool<F, SecureDataSocket<F, B>>> secureConnectionsPools;

    public static <F, B> SSLContext create$default$8() {
        return HttpClient$.MODULE$.create$default$8();
    }

    public static <F, B> int create$default$7() {
        return HttpClient$.MODULE$.create$default$7();
    }

    public static <F, B> AsynchronousChannelGroup create$default$6() {
        return HttpClient$.MODULE$.create$default$6();
    }

    public static <F, B> Executor create$default$5() {
        return HttpClient$.MODULE$.create$default$5();
    }

    public static <F, B> FiniteDuration create$default$4() {
        return HttpClient$.MODULE$.create$default$4();
    }

    public static <F, B> int create$default$3() {
        return HttpClient$.MODULE$.create$default$3();
    }

    public static <F, B> FiniteDuration create$default$2() {
        return HttpClient$.MODULE$.create$default$2();
    }

    public static <F, B> String create$default$1() {
        return HttpClient$.MODULE$.create$default$1();
    }

    public static <F, B> F create(String string, FiniteDuration finiteDuration, int n, FiniteDuration finiteDuration2, Executor executor, AsynchronousChannelGroup asynchronousChannelGroup, int n2, SSLContext sSLContext, Effect<F> effect, Scheduler<F> scheduler, BytesLike<B> bytesLike, ExecutionContext executionContext, Reporter reporter) {
        return HttpClient$.MODULE$.create(string, finiteDuration, n, finiteDuration2, executor, asynchronousChannelGroup, n2, sSLContext, effect, scheduler, bytesLike, executionContext, reporter);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public F apply(Request.Method method, URI uri, Seq<Tuple2<String, String>> headers, Option<Object> contentLength, Stream<F, B> body) {
        void var6_20;
        Seq seq;
        if (uri.getUserInfo() != null) {
            Tuple2 tuple2 = Headers$.MODULE$.basicAuthorization(uri.getUserInfo());
            seq = (Seq)headers.$plus$colon((Object)tuple2, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = headers;
        }
        Seq updatedHeaders = seq;
        Request request = new Request(method, this.pqFromUri(uri), updatedHeaders, contentLength, body, Request$.MODULE$.apply$default$6());
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        String string2 = null;
        String string3 = uri.getScheme();
        if ("http".equals(string3)) {
            bl = true;
            string = string3;
            if (uri.getPort() == -1) {
                F f = this.http(new InetSocketAddress(uri.getHost(), 80), request);
                return var6_20;
            }
        }
        if ("https".equals(string3)) {
            bl2 = true;
            string2 = string3;
            if (uri.getPort() == -1) {
                F f = this.https(new InetSocketAddress(uri.getHost(), 443), request);
                return var6_20;
            }
        }
        if (bl) {
            F f = this.http(new InetSocketAddress(uri.getHost(), uri.getPort()), request);
            return var6_20;
        }
        if (bl2) {
            F f = this.https(new InetSocketAddress(uri.getHost(), uri.getPort()), request);
            return var6_20;
        }
        boolean bl3 = "ws".equals(string3) ? true : "wss".equals(string3);
        if (bl3) {
            Object object = Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalArgumentException("Use HttpClient.webSocket() of HttpClient()"));
            return var6_20;
        }
        Object object = Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalArgumentException(new StringBuilder(17).append(string3).append(" is not supported").toString()));
        return var6_20;
    }

    public F https(InetSocketAddress address, Request<Stream<F, B>> request) {
        return (F)syntax$.MODULE$.EffectOps(this.takeSecureConnection(address), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)borrow -> this.http((AsyncResourcePool.Borrow)borrow, address.getHostName(), request));
    }

    public F http(InetSocketAddress address, Request<Stream<F, B>> request) {
        return (F)syntax$.MODULE$.EffectOps(this.takeRawConnection(address), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)borrow -> this.http((AsyncResourcePool.Borrow)borrow, address.getHostName(), request));
    }

    private F http(AsyncResourcePool.Borrow<F, DataSocket<F, B>> borrow, String host, Request<Stream<F, B>> request) {
        return (F)syntax$.MODULE$.EffectOps(this.http11().renderRequest(request.withHeader("Host", host), this.evidence$1), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)requestStream -> {
            DataSocket socket = (DataSocket)borrow.value();
            return syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(requestStream.foreach((Function1 & Serializable & scala.Serializable)bytes -> socket.write(bytes)), $this.evidence$1).start($this.executor), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)writeBytesFiber -> syntax$.MODULE$.EffectOps(this.http11().decodeResponse(Decoder$.MODULE$.apply(socket.stream(), $this.evidence$1), $this.evidence$1).pull(), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)maybeResponse -> {
                Object object;
                Option option = maybeResponse;
                if (option instanceof Some) {
                    Stream consumableBody;
                    Some some = (Some)option;
                    Response response = (Response)some.value();
                    Tuple2 tuple2 = ((Stream)response.body()).handleConsumed();
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object consumed = tuple2._1();
                    Stream consumableBody2 = (Stream)tuple2._2();
                    Tuple2 tuple22 = new Tuple2(consumed, (Object)consumableBody2);
                    Tuple2 tuple23 = tuple22;
                    Object consumed2 = tuple23._1();
                    Stream x$1 = consumableBody = (Stream)tuple23._2();
                    Response.Status x$2 = response.copy$default$1();
                    Seq x$3 = response.copy$default$3();
                    Option x$4 = response.copy$default$4();
                    object = syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(consumed2, $this.evidence$1).after((Function0 & Serializable & scala.Serializable)() -> writeBytesFiber.join()), $this.evidence$1).after((Function0 & Serializable & scala.Serializable)() -> borrow.give()), $this.evidence$1).start($this.executor), $this.evidence$1).as((Object)response.copy(x$2, (Object)x$1, x$3, x$4));
                } else if (None$.MODULE$.equals(option)) {
                    object = Effect$.MODULE$.apply($this.evidence$1).fail((Throwable)new IllegalStateException("Peer has closed connection before sending response."));
                } else {
                    throw new MatchError((Object)option);
                }
                return object;
            }));
        });
    }

    public F secureWebSocket(InetSocketAddress address, PathAndQuery path, Stream<F, WebSocketProtocol.Frame<B>> outgoingFrames, Map<String, String> cookie, Map<String, String> headers) {
        return (F)syntax$.MODULE$.EffectOps(this.takeRawConnection(address), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)borrow -> this.webSocket((AsyncResourcePool.Borrow)borrow, address.getHostName(), path, outgoingFrames, cookie, headers));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public F webSocket(URI uri, Stream<F, WebSocketProtocol.Frame<B>> outgoingFrames, Map<String, String> cookie, Map<String, String> headers) {
        void var5_18;
        PathAndQuery pq = this.pqFromUri(uri);
        Map updatedHeaders = uri.getUserInfo() != null ? headers.$plus(Headers$.MODULE$.basicAuthorization(uri.getUserInfo())) : headers;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        String string2 = null;
        String string3 = uri.getScheme();
        if ("ws".equals(string3)) {
            bl = true;
            string = string3;
            if (uri.getPort() == -1) {
                F f = this.webSocket(new InetSocketAddress(uri.getHost(), 80), pq, outgoingFrames, cookie, (Map<String, String>)updatedHeaders);
                return var5_18;
            }
        }
        if ("wss".equals(string3)) {
            bl2 = true;
            string2 = string3;
            if (uri.getPort() == -1) {
                F f = this.secureWebSocket(new InetSocketAddress(uri.getHost(), 443), pq, outgoingFrames, cookie, (Map<String, String>)updatedHeaders);
                return var5_18;
            }
        }
        if (bl) {
            F f = this.webSocket(new InetSocketAddress(uri.getHost(), uri.getPort()), pq, outgoingFrames, cookie, (Map<String, String>)updatedHeaders);
            return var5_18;
        }
        if (bl2) {
            F f = this.secureWebSocket(new InetSocketAddress(uri.getHost(), uri.getPort()), pq, outgoingFrames, cookie, (Map<String, String>)updatedHeaders);
            return var5_18;
        }
        boolean bl3 = "http".equals(string3) ? true : "https".equals(string3);
        if (bl3) {
            Object object = Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalArgumentException("Use HttpClient.http() of HttpClient.webSocket()"));
            return var5_18;
        }
        Object object = Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalArgumentException(new StringBuilder(17).append(string3).append(" is not supported").toString()));
        return var5_18;
    }

    public F webSocket(InetSocketAddress address, PathAndQuery path, Stream<F, WebSocketProtocol.Frame<B>> outgoingFrames, Map<String, String> cookie, Map<String, String> headers) {
        return (F)syntax$.MODULE$.EffectOps(this.takeRawConnection(address), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)borrow -> this.webSocket((AsyncResourcePool.Borrow)borrow, address.getHostName(), path, outgoingFrames, cookie, headers));
    }

    private F webSocket(AsyncResourcePool.Borrow<F, DataSocket<F, B>> borrow, String host, PathAndQuery path, Stream<F, WebSocketProtocol.Frame<B>> outgoingFrames, Map<String, String> cookie, Map<String, String> headers) {
        return (F)syntax$.MODULE$.EffectOps(WebSocketProtocol$Intention$.MODULE$.random(this.evidence$1), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)intention -> {
            Stream encodedOutgoingFrames = outgoingFrames.map((Function1 & Serializable & scala.Serializable)frame -> this.webSocketProtocol().encodeFrame((WebSocketProtocol.Frame)frame, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)123))));
            Request requestRaw = new Request((Request.Method)Request.Method$.Get$.MODULE$, path, headers.toSeq(), (Option)None$.MODULE$, (Object)encodedOutgoingFrames, Request$.MODULE$.apply$default$6());
            Request requestWithCookie = (Request)cookie.foldLeft((Object)requestRaw, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                Request acc;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        acc = (Request)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Request request = acc.withCookie(k, v);
                return request;
            });
            Request requestWithIntention = this.webSocketProtocol().addIntention(requestWithCookie, (WebSocketProtocol.Intention)intention);
            return syntax$.MODULE$.EffectOps(this.http(borrow, host, requestWithIntention), $this.evidence$1).map((Function1 & Serializable & scala.Serializable)rawResponse -> {
                Decoder frames;
                Decoder frameDecoder = Decoder$.MODULE$.apply((Stream)rawResponse.body(), $this.evidence$1);
                Decoder x$1 = frames = this.webSocketProtocol().mergeFrames(this.webSocketProtocol().decodeFrames(frameDecoder, $this.evidence$1), $this.evidence$1);
                Response.Status x$2 = rawResponse.copy$default$1();
                Seq x$3 = rawResponse.copy$default$3();
                Option x$4 = rawResponse.copy$default$4();
                return rawResponse.copy(x$2, x$1, x$3, x$4);
            });
        });
    }

    private PathAndQuery pqFromUri(URI uri) {
        String path = uri.getPath() == null ? "" : uri.getPath();
        String query = uri.getQuery() == null ? "" : uri.getQuery();
        return PathAndQuery$.MODULE$.fromString(new StringBuilder(0).append(path).append(query).toString());
    }

    private F takeRawConnection(InetSocketAddress address) {
        AsyncResourcePool pool = (AsyncResourcePool)this.rawConnectionsPools().getOrElseUpdate((Object)address, (Function0 & Serializable & scala.Serializable)() -> new AsyncResourcePool(new StringBuilder(16).append($this.name).append("-raw-socket-pool").toString(), (Function0 & Serializable & scala.Serializable)() -> this.factory$1(address), (Function0 & Serializable & scala.Serializable)() -> Effect$.MODULE$.apply($this.evidence$1).delay((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.nanoTime()), $this.maxConnectionsPerAddress, $this.maxIdleTime, $this.evidence$1, DataSocket$.MODULE$.dataSocketClose($this.evidence$1), $this.reporter));
        return (F)pool.borrow();
    }

    private F takeSecureConnection(InetSocketAddress address) {
        AsyncResourcePool pool = (AsyncResourcePool)this.secureConnectionsPools().getOrElseUpdate((Object)address, (Function0 & Serializable & scala.Serializable)() -> new AsyncResourcePool(new StringBuilder(16).append($this.name).append("-tls-socket-pool").toString(), (Function0 & Serializable & scala.Serializable)() -> this.factory$2(address), (Function0 & Serializable & scala.Serializable)() -> Effect$.MODULE$.apply($this.evidence$1).delay((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.nanoTime()), $this.maxConnectionsPerAddress, $this.maxIdleTime, $this.evidence$1, DataSocket$.MODULE$.dataSocketClose($this.evidence$1), $this.reporter));
        return (F)pool.borrow();
    }

    private Http11<B> http11() {
        return this.http11;
    }

    private WebSocketProtocol<B> webSocketProtocol() {
        return this.webSocketProtocol;
    }

    private TrieMap<InetSocketAddress, AsyncResourcePool<F, RawDataSocket<F, B>>> rawConnectionsPools() {
        return this.rawConnectionsPools;
    }

    private TrieMap<InetSocketAddress, AsyncResourcePool<F, SecureDataSocket<F, B>>> secureConnectionsPools() {
        return this.secureConnectionsPools;
    }

    private final Object factory$1(InetSocketAddress address$5) {
        return RawDataSocket$.MODULE$.connect(address$5, ByteBuffer.allocate(this.bufferSize), ByteBuffer.allocate(this.bufferSize), this.group, this.evidence$1, this.evidence$2);
    }

    private final Object factory$2(InetSocketAddress address$6) {
        return syntax$.MODULE$.EffectOps(RawDataSocket$.MODULE$.connect(address$6, ByteBuffer.allocate(this.bufferSize), ByteBuffer.allocate(this.bufferSize), this.group, this.evidence$1, this.evidence$2), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)rawSocket -> {
            $this.reporter.debug("%s - Connection established", (Object)$this.name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            SSLEngine engine = $this.sslContext.createSSLEngine(address$6.getHostName(), address$6.getPort());
            return syntax$.MODULE$.EffectOps(SecureDataSocket$.MODULE$.forClientMode(rawSocket, engine, $this.blockingExecutor, $this.evidence$1, $this.evidence$2), $this.evidence$1).map((Function1 & Serializable & scala.Serializable)socket -> {
                $this.reporter.debug("%s - TLS handshake finished", (Object)$this.name);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return socket;
            });
        });
    }

    public static final /* synthetic */ void $anonfun$new$3(HttpClient $this, List results) {
        block0: {
            int sum = BoxesRunTime.unboxToInt((Object)results.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            if (sum <= 0) break block0;
            $this.reporter.debug("HttpClient(%s) closes %d idle connection after timeout", (Object)$this.name, (Object)BoxesRunTime.boxToInteger((int)sum));
        }
    }

    public HttpClient(String name, FiniteDuration maxIdleTime, int maxConnectionsPerAddress, Executor blockingExecutor, AsynchronousChannelGroup group, int bufferSize, SSLContext sslContext, Stream<F, BoxedUnit> cleanupTicks, Effect<F> evidence$1, BytesLike<B> evidence$2, ExecutionContext executor, Reporter reporter) {
        this.name = name;
        this.maxIdleTime = maxIdleTime;
        this.maxConnectionsPerAddress = maxConnectionsPerAddress;
        this.blockingExecutor = blockingExecutor;
        this.group = group;
        this.bufferSize = bufferSize;
        this.sslContext = sslContext;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.executor = executor;
        this.reporter = reporter;
        syntax$.MODULE$.EffectOps(cleanupTicks.foreach((Function1 & Serializable & scala.Serializable)x$10 -> syntax$.MODULE$.EffectOps(syntax$.MODULE$.ListEffectOps((List)((TraversableOnce)this.rawConnectionsPools().values().$plus$plus((GenTraversableOnce)this.secureConnectionsPools().values(), Iterable$.MODULE$.canBuildFrom())).toList().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.cleanup(), List$.MODULE$.canBuildFrom()), $this.evidence$1).sequence(), $this.evidence$1).map((Function1 & Serializable & scala.Serializable)results -> {
            HttpClient.$anonfun$new$3(this, results);
            return BoxedUnit.UNIT;
        })), evidence$1).runAsyncForget(reporter);
        this.http11 = new Http11<B>(evidence$2);
        this.webSocketProtocol = new WebSocketProtocol<B>(evidence$2);
        this.rawConnectionsPools = TrieMap$.MODULE$.empty();
        this.secureConnectionsPools = TrieMap$.MODULE$.empty();
    }
}

